/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_tweaks.api.common.network.AbstractMessage;
import steve_gall.minecolonies_tweaks.core.common.CuriosCompat;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.item.ItemResourceScrollBook;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class ResourcescrollBookOpenMessage
extends AbstractMessage {
    public static final CustomPacketPayload.Type<ResourcescrollBookOpenMessage> TYPE = new CustomPacketPayload.Type(MineColoniesTweaks.rl("resourcescroll_book_open"));
    private final boolean request;
    private final ItemStack stack;

    public ResourcescrollBookOpenMessage() {
        this.request = true;
        this.stack = ItemStack.EMPTY;
    }

    public ResourcescrollBookOpenMessage(ItemStack stack) {
        this.request = false;
        this.stack = stack.copy();
    }

    public ResourcescrollBookOpenMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.request = buffer.readBoolean();
        this.stack = ItemSerializationHelper.deserialize((FriendlyByteBuf)buffer);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeBoolean(this.request);
        ItemSerializationHelper.serialize((FriendlyByteBuf)buffer, this.stack);
    }

    @Override
    public void handle(IPayloadContext context) {
        super.handle(context);
        if (this.request) {
            Player player = context.player();
            ItemStack stack = this.findResourcescrollBook(player);
            if (!stack.isEmpty()) {
                context.reply((CustomPacketPayload)new ResourcescrollBookOpenMessage(stack));
            }
        } else {
            Item item = this.stack.getItem();
            if (item instanceof ItemResourceScrollBook) {
                ItemResourceScrollBook item2 = (ItemResourceScrollBook)item;
                item2.openWindow((HolderLookup.Provider)context.player().registryAccess(), this.stack);
            }
        }
    }

    public ItemStack findResourcescrollBook(Player player) {
        ItemStack stack;
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack2 = inventory.getItem(i);
            if (!this.testResourcescrollBook(stack2)) continue;
            return stack2;
        }
        if (ModList.get().isLoaded("curios") && !(stack = CuriosCompat.findFirstCurio(player, this::testResourcescrollBook)).isEmpty()) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public boolean testResourcescrollBook(ItemStack stack) {
        return stack.getItem() instanceof ItemResourceScrollBook;
    }

    public CustomPacketPayload.Type<ResourcescrollBookOpenMessage> type() {
        return TYPE;
    }

    public boolean isRequest() {
        return this.request;
    }

    public ItemStack getStack() {
        return this.stack.copy();
    }
}

