/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.item.capability;

import com.minecolonies.api.items.ModItems;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class LargeBottleCapabilityProvider
implements IFluidHandlerItem {
    private ItemStack container;

    public LargeBottleCapabilityProvider(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public FluidStack getFluid() {
        if (this.container.is(ModItems.large_empty_bottle)) {
            return FluidStack.EMPTY;
        }
        if (this.container.is(ModItems.large_water_bottle)) {
            return new FluidStack((Fluid)Fluids.WATER, 1000);
        }
        if (this.container.is(ModItems.large_milk_bottle) && NeoForgeMod.MILK.isBound()) {
            return new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000);
        }
        return FluidStack.EMPTY;
    }

    public boolean canFillFluidType(FluidStack resource) {
        return resource.is((Fluid)Fluids.WATER) || NeoForgeMod.MILK.isBound() && resource.is((Fluid)NeoForgeMod.MILK.get());
    }

    public void setFluid(FluidStack resource) {
        if (resource.isEmpty()) {
            this.container = ModItems.large_empty_bottle.getDefaultInstance();
        } else if (resource.getFluid().isSame((Fluid)Fluids.WATER)) {
            this.container = ModItems.large_water_bottle.getDefaultInstance();
        } else if (NeoForgeMod.MILK.isBound() && resource.getFluid().isSame((Fluid)NeoForgeMod.MILK.get())) {
            this.container = ModItems.large_milk_bottle.getDefaultInstance();
        }
    }

    public int getTanks() {
        return 1;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public boolean isFluidValid(int tank, FluidStack resource) {
        return this.canFillFluidType(resource);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 1000 || !this.container.is(ModItems.large_empty_bottle) || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(resource);
        }
        return 1000;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || maxDrain < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

