/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.item;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.core.client.gui.ResourceScrollBookListWindow;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksDataComponents;
import steve_gall.minecolonies_tweaks.core.common.inventory.ResourceScrollBookInventoryMenu;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class ItemResourceScrollBook
extends Item {
    public static final List<Component> TOOLTIPS = Arrays.asList(Component.translatable((String)"item.minecolonies_tweaks.resourcescroll_book.tooltip1"), Component.translatable((String)"item.minecolonies_tweaks.resourcescroll_book.tooltip2"));
    private final int slots;

    public ItemResourceScrollBook(Item.Properties properites, int slots) {
        super(properites.stacksTo(1));
        this.slots = slots;
    }

    public Container getContainer(HolderLookup.Provider provider, ItemStack stack) {
        return new Container(provider, stack);
    }

    public int getSlots() {
        return this.slots;
    }

    public void setItems(HolderLookup.Provider provider, ItemStack stack, List<ItemStack> slots) {
        CompoundTag compound = new CompoundTag();
        ListTag slotsTag = new ListTag();
        compound.put("slots", (Tag)slotsTag);
        int count = slots.size();
        int size = Math.max(count, this.slots);
        for (int i = 0; i < size; ++i) {
            ItemStack slot = i < count ? slots.get(i) : ItemStack.EMPTY;
            slotsTag.add((Object)ItemSerializationHelper.serializeTag(provider, slot));
        }
        stack.set(MCTweaksDataComponents.RESOURCESCROLL_BOOK_ITEMS, (Object)compound);
    }

    public NonNullList<ItemStack> getItems(HolderLookup.Provider provider, ItemStack stack) {
        CompoundTag compound = (CompoundTag)stack.get(MCTweaksDataComponents.RESOURCESCROLL_BOOK_ITEMS);
        NonNullList items = NonNullList.withSize((int)this.slots, (Object)ItemStack.EMPTY);
        if (compound != null) {
            ListTag slots = compound.getList("slots", 10);
            int size = slots.size();
            for (int i = 0; i < size; ++i) {
                CompoundTag slotTag = slots.getCompound(i);
                ItemStack slot = ItemSerializationHelper.deserializeTag(provider, slotTag);
                items.set(i, (Object)slot);
            }
        }
        return items;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.addAll(TOOLTIPS);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        ItemStack stack = player.getItemInHand(context.getHand());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isShiftKeyDown()) {
                this.openInventory(serverPlayer, stack, this.getHandSlot(player, context.getHand()));
            }
        } else if (!player.isShiftKeyDown()) {
            this.openWindow((HolderLookup.Provider)context.getLevel().registryAccess(), stack);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isShiftKeyDown()) {
                this.openInventory(serverPlayer, stack, this.getHandSlot(player, hand));
            }
        } else if (!player.isShiftKeyDown()) {
            this.openWindow((HolderLookup.Provider)level.registryAccess(), stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void openWindow(HolderLookup.Provider provider, ItemStack stack) {
        new ResourceScrollBookListWindow(null, (List<ItemStack>)this.getItems(provider, stack)).open();
    }

    public void openInventory(ServerPlayer player, final ItemStack stack, final int slot) {
        player.openMenu(new MenuProvider(){

            public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                return new ResourceScrollBookInventoryMenu(windowId, inventory, slot);
            }

            public Component getDisplayName() {
                return stack.getHoverName();
            }
        }, buf -> buf.writeInt(slot));
    }

    public int getHandSlot(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return player.getInventory().selected;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return 40;
        }
        return -1;
    }

    public class Container
    implements net.minecraft.world.Container {
        private final HolderLookup.Provider provider;
        private final ItemStack stack;
        private final List<ItemStack> items;

        public Container(HolderLookup.Provider provider, ItemStack stack) {
            this.provider = provider;
            this.stack = stack;
            this.items = ItemResourceScrollBook.this.getItems(provider, stack);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public void clearContent() {
            for (int i = 0; i < this.getContainerSize(); ++i) {
                this.items.set(i, ItemStack.EMPTY);
            }
            this.setChanged();
        }

        public int getContainerSize() {
            return ItemResourceScrollBook.this.getSlots();
        }

        public boolean isEmpty() {
            for (ItemStack stack : this.items) {
                if (stack.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int slot) {
            return this.items.get(slot);
        }

        public ItemStack removeItem(int slot, int count) {
            ItemStack stack = ContainerHelper.removeItem(this.items, (int)slot, (int)count);
            if (!stack.isEmpty()) {
                this.setChanged();
            }
            return stack;
        }

        public ItemStack removeItemNoUpdate(int slot) {
            ItemStack stack = this.items.get(slot);
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            this.items.set(slot, ItemStack.EMPTY);
            return stack;
        }

        public void setItem(int slot, ItemStack stack) {
            this.items.set(slot, stack);
            int maxStackSize = this.getMaxStackSize();
            if (!stack.isEmpty() && stack.getCount() > maxStackSize) {
                stack.setCount(maxStackSize);
            }
            this.setChanged();
        }

        public void setChanged() {
            ItemResourceScrollBook.this.setItems(this.provider, this.stack, this.items);
        }

        public boolean stillValid(Player player) {
            return false;
        }
    }
}

