/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.inventory;

import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksItems;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksMenuTypes;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksTags;
import steve_gall.minecolonies_tweaks.core.common.item.ItemResourceScrollBook;

public class ResourceScrollBookInventoryMenu
extends AbstractContainerMenu {
    private final Inventory inventory;
    private final int bookSlot;
    private final ItemResourceScrollBook.Container container;

    public static ResourceScrollBookInventoryMenu create(int windowId, Inventory inventory, RegistryFriendlyByteBuf extraData) {
        int bookSlot = extraData.readInt();
        return new ResourceScrollBookInventoryMenu(windowId, inventory, bookSlot);
    }

    public ResourceScrollBookInventoryMenu(int windowId, Inventory inventory, int bookSlot) {
        super((MenuType)MCTweaksMenuTypes.RESOURCESCROLL_BOOK_INVENTORY.get(), windowId);
        int xi;
        int i;
        this.inventory = inventory;
        this.bookSlot = bookSlot;
        this.container = ((ItemResourceScrollBook)((Object)MCTweaksItems.RESOURCESCROLL_BOOK.get())).getContainer((HolderLookup.Provider)inventory.player.registryAccess(), this.getBook());
        for (i = 0; i < this.container.getContainerSize(); ++i) {
            xi = i % 9;
            int yi = i / 9;
            this.addSlot(new BookSlot(this, this.container, i, 8 + xi * 18, 18 + yi * 18));
        }
        i = ((this.container.getContainerSize() + 8) / 9 - 4) * 18;
        for (int yi = 0; yi < 3; ++yi) {
            for (int xi2 = 0; xi2 < 9; ++xi2) {
                int slot = xi2 + (yi + 1) * 9;
                this.addSlot(new InventorySlot(inventory, slot, 8 + xi2 * 18, 103 + yi * 18 + i));
            }
        }
        for (xi = 0; xi < 9; ++xi) {
            int slot = xi;
            this.addSlot(new InventorySlot(inventory, slot, 8 + xi * 18, 161 + i));
        }
    }

    public ItemStack getBook() {
        return this.inventory.getItem(this.getBookSlot());
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (slotIndex < this.container.getContainerSize() ? !this.moveItemStackTo(stack, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(stack, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public ItemResourceScrollBook.Container getContainer() {
        return this.container;
    }

    public int getBookSlot() {
        return this.bookSlot;
    }

    public boolean stillValid(Player player) {
        return this.getBook().is((Item)MCTweaksItems.RESOURCESCROLL_BOOK.get());
    }

    public class BookSlot
    extends Slot {
        public BookSlot(ResourceScrollBookInventoryMenu this$0, ItemResourceScrollBook.Container container, int slot, int x, int y) {
            super((Container)container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.is(MCTweaksTags.Items.RESOURCESCROLLBOOK_ELEMENT);
        }
    }

    public class InventorySlot
    extends Slot {
        public InventorySlot(Inventory inventory, int slot, int x, int y) {
            super((Container)inventory, slot, x, y);
        }

        public boolean mayPickup(Player player) {
            return this.getSlotIndex() != ResourceScrollBookInventoryMenu.this.getBookSlot();
        }
    }
}

