/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.fluid;

import com.minecolonies.api.util.Utils;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidSerializationHelper {
    public static void serialize(FriendlyByteBuf buf, FluidStack stack) {
        Utils.serializeCodecMess((StreamCodec)FluidStack.STREAM_CODEC, (RegistryFriendlyByteBuf)((RegistryFriendlyByteBuf)buf), (Object)stack);
    }

    public static FluidStack deserialize(FriendlyByteBuf buf) {
        return (FluidStack)Utils.deserializeCodecMess((StreamCodec)FluidStack.STREAM_CODEC, (RegistryFriendlyByteBuf)((RegistryFriendlyByteBuf)buf));
    }

    public static Function<FluidStack, CompoundTag> serializerTag(HolderLookup.Provider provider) {
        return stack -> FluidSerializationHelper.serializeTag(provider, stack);
    }

    public static Function<CompoundTag, FluidStack> deserializerTag(HolderLookup.Provider provider) {
        return tag -> FluidSerializationHelper.deserializeTag(provider, tag);
    }

    public static CompoundTag serializeTag(HolderLookup.Provider provider, FluidStack stack) {
        return (CompoundTag)stack.saveOptional(provider);
    }

    public static FluidStack deserializeTag(HolderLookup.Provider provider, CompoundTag tag) {
        return FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
    }

    private FluidSerializationHelper() {
    }
}

