/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.colony;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public record BuildingCost(BlockPos id, List<ItemStorage> costs) {
    public static final String TAG_ID = "id";
    public static final String TAG_COSTS = "costs";

    public static BuildingCost deserialize(HolderLookup.Provider provider, CompoundTag tag) {
        BlockPos id = BlockPosUtil.read((CompoundTag)tag, (String)TAG_ID);
        List<ItemStorage> costs = NBTUtils.streamCompound((ListTag)tag.getList(TAG_COSTS, 10)).map(SerializationHelper.deserializerTag(provider)).toList();
        return new BuildingCost(id, costs);
    }

    public static CompoundTag serialize(HolderLookup.Provider provider, BuildingCost data) {
        CompoundTag tag = new CompoundTag();
        BlockPosUtil.write((CompoundTag)tag, (String)TAG_ID, (BlockPos)data.id);
        ListTag costsTag = (ListTag)data.costs.stream().map(SerializationHelper.serializerTag(provider)).collect(NBTUtils.toListNBT());
        tag.put(TAG_COSTS, (Tag)costsTag);
        return tag;
    }

    public static BuildingCost decode(RegistryFriendlyByteBuf buffer) {
        BlockPos id = buffer.readBlockPos();
        List costs = buffer.readList(SerializationHelper::deserialize);
        return new BuildingCost(id, costs);
    }

    public static void encode(RegistryFriendlyByteBuf buffer, BuildingCost data) {
        buffer.writeBlockPos(data.id);
        buffer.writeCollection(data.costs, SerializationHelper::serialize);
    }
}

