/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.colony;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import steve_gall.minecolonies_tweaks.core.common.colony.BuildingCost;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public class BatchRepairData {
    public static final String TAG_COSTS = "costs";
    public static final String TAG_MARK_AS_DONT_REPAIRS = "markAsDontRepairs";
    private final List<BuildingCost> costs = new ArrayList<BuildingCost>();
    private final List<BlockPos> markAsDontRepairs = new ArrayList<BlockPos>();

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.costs.clear();
        NBTUtils.streamCompound((ListTag)tag.getList(TAG_COSTS, 10)).map(SerializationHelper.apply(provider, BuildingCost::deserialize)).forEach(this.costs::add);
        this.markAsDontRepairs.clear();
        this.markAsDontRepairs.addAll(BlockPosUtil.readPosListFromNBT((CompoundTag)tag, (String)TAG_MARK_AS_DONT_REPAIRS));
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.put(TAG_COSTS, (Tag)this.costs.stream().map(SerializationHelper.apply(provider, BuildingCost::serialize)).collect(NBTUtils.toListNBT()));
        BlockPosUtil.writePosListToNBT((CompoundTag)tag, (String)TAG_MARK_AS_DONT_REPAIRS, this.markAsDontRepairs);
        return tag;
    }

    public void deserializeBuffer(RegistryFriendlyByteBuf buffer) {
        this.costs.clear();
        buffer.readList(SerializationHelper.reader(BuildingCost::decode)).forEach(this.costs::add);
        this.markAsDontRepairs.clear();
        buffer.readList(FriendlyByteBuf::readBlockPos).forEach(this.markAsDontRepairs::add);
    }

    public void serializeBuffer(RegistryFriendlyByteBuf buffer) {
        buffer.writeCollection(this.costs, SerializationHelper.writer(BuildingCost::encode));
        buffer.writeCollection(this.markAsDontRepairs, FriendlyByteBuf::writeBlockPos);
    }

    public List<BuildingCost> getCosts() {
        return this.costs;
    }

    public List<BlockPos> getMarkAsDontRepairs() {
        return this.markAsDontRepairs;
    }
}

