/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.building;

import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class BuildingEmptySlotCounter {
    private static final DecimalFormat SLOTS_FORMAT = new DecimalFormat("#,###");
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("0.0");
    private static final int EMPTY_SLOTS_UPDATE_TICKS = 20;
    private final IBuildingView buildingView;
    private boolean first = true;
    private List<BlockPos> positions = null;
    private int ticks = 0;
    private int emptySlots = 0;
    private int totalSlots = 0;

    public BuildingEmptySlotCounter(IBuildingView buildingView) {
        this.buildingView = buildingView;
    }

    public boolean update() {
        if (this.first) {
            this.first = false;
            this.updatePositions();
            for (BlockPos position : this.positions) {
                this.countUp(position);
            }
            return true;
        }
        if (this.ticks == 0) {
            this.emptySlots = 0;
            this.totalSlots = 0;
            this.updatePositions();
        }
        int containerCount = this.positions.size();
        int count = (containerCount + 20 - 1) / 20;
        int offset = this.ticks * count;
        int endIndex = Math.min(offset + count, containerCount);
        for (int i = offset; i < endIndex; ++i) {
            this.countUp(this.positions.get(i));
        }
        ++this.ticks;
        if (this.ticks >= 20) {
            this.ticks = 0;
            return true;
        }
        return false;
    }

    private void updatePositions() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(this.buildingView.getPosition());
        positions.addAll(this.buildingView.getContainers());
        this.positions = positions;
    }

    private void countUp(BlockPos position) {
        Level level = this.buildingView.getColony().getWorld();
        BlockEntity blockEntity = level.getBlockEntity(position);
        IItemHandler itemHandler = this.getItemHandler(blockEntity);
        if (itemHandler == null) {
            return;
        }
        int slots = itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            if (itemHandler.getStackInSlot(i).isEmpty()) {
                ++this.emptySlots;
            }
            ++this.totalSlots;
        }
    }

    private IItemHandler getItemHandler(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        if (blockEntity instanceof AbstractTileEntityRack) {
            AbstractTileEntityRack rack = (AbstractTileEntityRack)blockEntity;
            return rack.getInventory();
        }
        return IItemHandlerCapProvider.wrap((BlockEntity)blockEntity).getItemHandlerCap();
    }

    public IBuildingView getBuildingView() {
        return this.buildingView;
    }

    public int getEmptySlots() {
        return this.emptySlots;
    }

    public int getTotalSlots() {
        return this.totalSlots;
    }

    public Component getSlotsText() {
        String s1 = SLOTS_FORMAT.format(this.emptySlots);
        String s2 = SLOTS_FORMAT.format(this.totalSlots);
        return Component.translatable((String)"minecolonies_tweaks.gui.warehouse.empty_slots", (Object[])new Object[]{s1, s2});
    }

    public String getPercentText() {
        return PERCENT_FORMAT.format((float)this.emptySlots / ((float)this.totalSlots / 100.0f)) + "%";
    }
}

