/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common;

import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.manager.RequestMappingHandler;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.items.ItemLargeBottle;
import com.minecolonies.core.items.ItemResourceScroll;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import steve_gall.minecolonies_tweaks.api.common.building.module.ModuleRegisterEvent;
import steve_gall.minecolonies_tweaks.api.common.network.MessageRegistrar;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableDeliverable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableRequestable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.RequestableObjectRegistry;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.resolvers.CustomizableRequestResolverFactory;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;
import steve_gall.minecolonies_tweaks.core.client.MineColoniesTweaksClient;
import steve_gall.minecolonies_tweaks.core.common.CommonForgeEventHandler;
import steve_gall.minecolonies_tweaks.core.common.block.MinecoloniesCropBlockExtension;
import steve_gall.minecolonies_tweaks.core.common.building.module.CustomCraftingModule;
import steve_gall.minecolonies_tweaks.core.common.command.MCTweaksCommands;
import steve_gall.minecolonies_tweaks.core.common.config.MCTweaksConfigClient;
import steve_gall.minecolonies_tweaks.core.common.config.MCTweaksConfigCommon;
import steve_gall.minecolonies_tweaks.core.common.config.MCTweaksConfigServer;
import steve_gall.minecolonies_tweaks.core.common.crafting.CustomizableRecipeStorageFactory;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksBuildingModules;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksDataComponents;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksEquipmentTypes;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksItems;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksMenuTypes;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksRecipes;
import steve_gall.minecolonies_tweaks.core.common.item.CompostDispenseItemBehavior;
import steve_gall.minecolonies_tweaks.core.common.item.ItemCropExtension;
import steve_gall.minecolonies_tweaks.core.common.item.capability.LargeBottleCapabilityProvider;
import steve_gall.minecolonies_tweaks.core.common.network.MCTweaksMessagesRegistrar;
import steve_gall.minecolonies_tweaks.core.common.requestsystem.CustomizableDeliverableRequest;
import steve_gall.minecolonies_tweaks.core.common.requestsystem.CustomizableDeliverableRequestFactory;
import steve_gall.minecolonies_tweaks.core.common.requestsystem.CustomizableRequestableRequest;
import steve_gall.minecolonies_tweaks.core.common.requestsystem.CustomizableRequestableRequestFactory;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCost;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCostResolver;

@Mod(value="minecolonies_tweaks")
public class MineColoniesTweaks {
    public static final String MOD_ID = "minecolonies_tweaks";
    public static final Logger LOGGER = LogManager.getLogger();

    public MineColoniesTweaks(FMLModContainer modContainer, Dist dist) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MCTweaksConfigClient.SPEC);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MCTweaksConfigCommon.SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MCTweaksConfigServer.SPEC);
        IEventBus fml_bus = modContainer.getEventBus();
        MCTweaksDataComponents.REGISTER.register(fml_bus);
        MCTweaksItems.REGISTER.register(fml_bus);
        MCTweaksRecipes.SERIALIZERS.register(fml_bus);
        MCTweaksMenuTypes.REGISTER.register(fml_bus);
        MCTweaksEquipmentTypes.REGISTER.register(fml_bus);
        fml_bus.addListener(this::onFMLCommonSetup);
        fml_bus.addListener(this::onRegister);
        fml_bus.addListener(this::onModuleRegister);
        fml_bus.addListener(e -> this.onConfigReload((ModConfigEvent)e));
        fml_bus.addListener(e -> this.onConfigReload((ModConfigEvent)e));
        fml_bus.addListener(this::onBuildCreativeModeTabContents);
        fml_bus.addListener(this::onRegisterPayloadHandlers);
        fml_bus.addListener(this::onAttachCapabilitiesItemStackEvent);
        IEventBus forge_bus = NeoForge.EVENT_BUS;
        forge_bus.addListener(e -> MCTweaksCommands.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        forge_bus.register((Object)new CommonForgeEventHandler());
        if (dist.isClient()) {
            new MineColoniesTweaksClient(modContainer);
        }
        NeoForgeMod.enableMilkFluid();
    }

    private void onFMLCommonSetup(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            ModLoader.postEvent((Event)new ModuleRegisterEvent());
            StandardFactoryController.getInstance().registerNewFactory((IFactory)new CustomizableRequestableRequestFactory());
            StandardFactoryController.getInstance().registerNewFactory((IFactory)new CustomizableDeliverableRequestFactory());
            StandardFactoryController.getInstance().registerNewFactory((IFactory)new CustomizableRecipeStorageFactory());
            RequestMappingHandler.registerRequestableTypeMapping(CustomizableRequestable.class, CustomizableRequestableRequest.class);
            RequestMappingHandler.registerRequestableTypeMapping(CustomizableDeliverable.class, CustomizableDeliverableRequest.class);
            StandardFactoryController.getInstance().registerNewFactory(new CustomizableRequestResolverFactory<ResearchCostResolver>(ResearchCostResolver.class, 20700, ResearchCostResolver::serialize, ResearchCostResolver::deserialize));
            RequestableObjectRegistry.INSTANCE.register(ResearchCost.ID, ResearchCost::serialize, ResearchCost::deserialize);
            DispenserBlock.registerBehavior((ItemLike)ModItems.compost, (DispenseItemBehavior)new CompostDispenseItemBehavior());
        });
    }

    private void onModuleRegister(ModuleRegisterEvent e) {
        CustomCraftingModule.loadCustomCraftingModules();
        for (DeferredHolder buildingEntry : Arrays.asList(ModBuildings.alchemist, ModBuildings.blacksmith, ModBuildings.concreteMixer, ModBuildings.crusher, ModBuildings.dyer, ModBuildings.fletcher, ModBuildings.glassblower, ModBuildings.mechanic, ModBuildings.plantation, ModBuildings.sawmill, ModBuildings.stoneMason, ModBuildings.stoneSmelter, ModBuildings.university)) {
            List moduleProducers = ((BuildingEntry)buildingEntry.get()).getModuleProducers();
            if (moduleProducers.contains(BuildingModules.MIN_STOCK)) continue;
            moduleProducers.add(BuildingModules.MIN_STOCK);
        }
        ((BuildingEntry)ModBuildings.university.get()).getModuleProducers().add(MCTweaksBuildingModules.RESEARCH_COST_RESOLVER);
        ((BuildingEntry)ModBuildings.wareHouse.get()).getModuleProducers().add(MCTweaksBuildingModules.MAXIMUM_STOCK);
        ((BuildingEntry)ModBuildings.library.get()).getModuleProducers().add(MCTweaksBuildingModules.STUDY_ITEM_BLACKLIST);
    }

    private void onRegister(RegisterEvent e) {
        if (e.getRegistryKey() == MCTweaksEquipmentTypes.REGISTER.getRegistryKey()) {
            CustomToolType.init();
            ResourceKey registryKey = e.getRegistryKey();
            for (CustomToolType type : CustomToolType.list()) {
                e.register(registryKey, type.getName(), () -> {
                    EquipmentTypeEntry.Builder builder = new EquipmentTypeEntry.Builder();
                    builder.setRegistryName(type.getName());
                    builder.setDisplayName(type.getDisplayName());
                    builder.setIsEquipment((stack, b) -> false);
                    builder.setEquipmentLevel((stack, b) -> -1);
                    EquipmentTypeEntry build = builder.build();
                    type.pair(build);
                    return build;
                });
            }
        }
    }

    private void onConfigReload(ModConfigEvent e) {
        if (e.getConfig().getSpec() == MCTweaksConfigServer.SPEC) {
            Object extension;
            for (Block block : BuiltInRegistries.BLOCK) {
                if (!(block instanceof MinecoloniesCropBlockExtension)) continue;
                extension = (MinecoloniesCropBlockExtension)block;
                extension.minecolonies_tweaks$onServerConfigReloaded();
            }
            for (Item item : BuiltInRegistries.ITEM) {
                if (!(item instanceof ItemCropExtension)) continue;
                extension = (ItemCropExtension)item;
                extension.minecolonies_tweaks$onServerConfigReloaded();
            }
        }
    }

    private void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent e) {
        if (e.getTab() == ModCreativeTabs.GENERAL.get()) {
            for (DeferredHolder<Item, ItemResourceScroll> deferredHolder : MCTweaksItems.COLOR_RESOURCE_SCROLLS.values()) {
                e.accept((ItemLike)deferredHolder.get());
            }
            e.accept((ItemLike)MCTweaksItems.INVENTORYSCROLL.get());
            for (DeferredHolder deferredHolder : MCTweaksItems.COLOR_INVENTORY_SCROLLS.values()) {
                e.accept((ItemLike)deferredHolder.get());
            }
            e.accept((ItemLike)MCTweaksItems.UNIVERSITYSCROLL.get());
            e.accept((ItemLike)MCTweaksItems.RESOURCESCROLL_BOOK.get());
            e.accept((ItemLike)MCTweaksItems.COPYSCROLL.get());
        }
    }

    private void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        String modVersion = ((ModContainer)ModList.get().getModContainerById(MOD_ID).get()).getModInfo().getVersion().toString();
        MessageRegistrar registry = new MessageRegistrar(event.registrar(MOD_ID).versioned(modVersion));
        MCTweaksMessagesRegistrar.register(registry);
    }

    private void onAttachCapabilitiesItemStackEvent(RegisterCapabilitiesEvent e) {
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof ItemLargeBottle)) continue;
            e.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new LargeBottleCapabilityProvider((ItemStack)stack), new ItemLike[]{item});
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

