/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.component.ColonyId;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import steve_gall.minecolonies_tweaks.api.client.gui.ResourceScrollBookElement;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.ItemClipboardAccessor;

public class ClipboardElement
extends ResourceScrollBookElement {
    private Component colonyName = EMPTY;
    private Component requestCount = EMPTY;

    public ClipboardElement(ItemStack stack) {
        super(stack);
    }

    @Override
    public void onOpenClicked() {
        super.onOpenClicked();
        Minecraft mc = Minecraft.getInstance();
        ItemClipboardAccessor.invokeOpenWindow(this.stack, (Level)mc.level, (Player)mc.player);
    }

    @Override
    public void update() {
        super.update();
        IColonyView colonyView = this.getColonyView();
        if (colonyView == null) {
            this.colonyName = EMPTY;
            this.requestCount = COLONY_NOT_SETTED;
            return;
        }
        this.valid = true;
        this.colonyName = Component.literal((String)colonyView.getName()).withStyle(ChatFormatting.DARK_PURPLE);
        int requestCount = 0;
        for (IBuildingView buildingView : colonyView.getClientBuildingManager().getBuildings().values()) {
            requestCount += buildingView.getOpenRequestsOfBuilding().size();
        }
        this.requestCount = Component.translatable((String)"minecolonies_tweaks.gui.resourcebook.open_requests", (Object[])new Object[]{requestCount});
    }

    @Override
    public void update(int index, Pane rowPane) {
        super.update(index, rowPane);
        this.getDesc1Label(rowPane).setText(this.colonyName);
        this.getDesc2Label(rowPane).setText(this.requestCount);
    }

    public IColonyView getColonyView() {
        return ColonyId.readColonyViewFromItemStack((ItemStack)this.stack);
    }
}

