/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.requestsystem.resolvers;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableRequestable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IRequestableObject;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.resolvers.ICustomizableRequestResolver;

public abstract class CustomizableRequestableResolver<REQUESTABLE extends IRequestableObject>
extends AbstractRequestResolver<CustomizableRequestable>
implements ICustomizableRequestResolver<REQUESTABLE> {
    public CustomizableRequestableResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    public abstract boolean canResolveRequest(@NotNull IRequestManager var1, @NotNull IRequester var2, @NotNull IRequestableObject var3);

    @Nullable
    public abstract List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager var1, @NotNull IRequester var2, @NotNull REQUESTABLE var3);

    public abstract void resolveRequest(@NotNull IRequestManager var1, @NotNull IRequester var2, @NotNull REQUESTABLE var3);

    public boolean canResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends CustomizableRequestable> request) {
        return this.canResolveRequest(manager, request.getRequester(), ((CustomizableRequestable)request.getRequest()).getObject());
    }

    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends CustomizableRequestable> request) {
        return this.attemptResolveRequest(manager, request.getRequester(), this.getRequestableObject(request));
    }

    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends CustomizableRequestable> request) {
        this.resolveRequest(manager, request.getRequester(), this.getRequestableObject(request));
        manager.updateRequestState(request.getId(), RequestState.RESOLVED);
    }

    public boolean isValid() {
        return true;
    }
}

