/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.reliquary;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.Utils;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reliquary.entity.shot.NeutralShot;
import reliquary.entity.shot.ShotBase;
import reliquary.init.ModItems;
import reliquary.init.ModSounds;
import reliquary.item.HandgunItem;
import reliquary.item.MagazineItem;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAIContext;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizedAIGunner;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.GunnerAmmo;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.AttackDelayConfig;
import steve_gall.minecolonies_compatibility.mixin.common.reliquary.HandgunItemAccessor;
import steve_gall.minecolonies_compatibility.module.common.reliquary.Magazine;
import steve_gall.minecolonies_compatibility.module.common.reliquary.ReliquaryConfig;

public class GunnerHandgunAI
extends CustomizedAIGunner {
    public static final String TAG_KEY = MineColoniesCompatibility.rl("reliquary_gunner_handgun").toString();
    public static final String TAG_DAMAGE = MineColoniesCompatibility.rl("damage").toString();

    @Override
    public boolean test(@NotNull CustomizedAIContext context) {
        return super.test(context) && context.getWeapon().getItem() instanceof HandgunItem;
    }

    @Override
    @NotNull
    public String getTagKey() {
        return TAG_KEY;
    }

    public ReliquaryConfig.JobConfig.GunnerHandgunConfig getWeaponConfig() {
        return MineColoniesCompatibilityConfigServer.INSTANCE.modules.reliquary.job.gunnerHandgun;
    }

    @Override
    protected boolean testAmmo(@NotNull AbstractEntityCitizen user, @NotNull ItemStack stack) {
        MagazineItem item;
        Item item2 = stack.getItem();
        return item2 instanceof MagazineItem && (item = (MagazineItem)item2) != ModItems.EMPTY_MAGAZINE.get();
    }

    @Override
    @Nullable
    protected GunnerAmmo createAmmoRequest(@NotNull AbstractEntityCitizen user, int minCount) {
        return new Magazine(minCount);
    }

    @Override
    protected boolean isAmmoRequest(@NotNull AbstractEntityCitizen user, @NotNull GunnerAmmo object) {
        return object instanceof Magazine;
    }

    @Override
    protected int getAmmoMinRequestCount(@NotNull AbstractEntityCitizen user) {
        return 2;
    }

    @Override
    @Nullable
    protected AttackDelayConfig getAttackDealyConfig() {
        return this.getWeaponConfig().attackDelay;
    }

    @Override
    protected int getReloadTimerDuration() {
        return (Integer)this.getWeaponConfig().reloadDuration.get();
    }

    @Override
    protected boolean isNeedRequestAmmo(@NotNull AbstractEntityCitizen user) {
        return super.isNeedRequestAmmo(user) && this.getBulletCount(user) <= 0;
    }

    @Override
    public boolean reload(@NotNull AbstractEntityCitizen user, boolean forRangedAttack) {
        InventoryCitizen inventory = user.getInventoryCitizen();
        int magazineSlot = this.getAmmoSlot(user, (IItemHandler)inventory);
        if (this.getBulletCount(user) <= 0 || magazineSlot > -1 && this.getMagazineType(user).isEmpty()) {
            if (magazineSlot > -1) {
                ItemStack magazine = inventory.extractItem(magazineSlot, 1, false);
                this.setMagazineType(user, BuiltInRegistries.ITEM.getKey((Object)magazine.getItem()).toString());
                this.setPotionContents(user, (PotionContents)magazine.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY));
                this.insertItem(user, (IItemHandler)inventory, new ItemStack((ItemLike)ModItems.EMPTY_MAGAZINE.get()));
            } else if (this.getBulletMode().canDefault()) {
                this.setMagazineType(user, "");
                this.setPotionContents(user, PotionContents.EMPTY);
            } else {
                return false;
            }
            this.setBulletCount(user, 8);
            this.startReloadTimer(user);
            return false;
        }
        return true;
    }

    @Override
    protected void onReloadTimerStarted(@NotNull AbstractEntityCitizen user) {
        super.onReloadTimerStarted(user);
        user.playSound((SoundEvent)ModSounds.HANDGUN_LOAD.get(), 0.25f, 1.0f);
    }

    @Override
    public void doRangedAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        ItemStack weapon = this.getMainHandItem(user);
        Item item = weapon.getItem();
        if (item instanceof HandgunItemAccessor) {
            HandgunItemAccessor accessor = (HandgunItemAccessor)item;
            this.doRangedAttack(user, target, accessor);
        }
    }

    private void doRangedAttack(AbstractEntityCitizen user, LivingEntity target, HandgunItemAccessor accessor) {
        String rawMagazineType = this.getMagazineType(user);
        ResourceLocation magazineType = ResourceLocation.tryParse((String)rawMagazineType);
        Map<ResourceLocation, HandgunItem.IShotFactory> magazineShotFactories = accessor.getMagazineShotFactories();
        HandgunItem.IShotFactory shotfactory = null;
        if (rawMagazineType.isEmpty()) {
            shotfactory = (level, player, hand) -> {
                NeutralShot shot = new NeutralShot(level, player, hand);
                double damage = this.getWeaponConfig().defaultBulletDamage.apply(user, this.getPrimarySkillLevel(user));
                shot.getPersistentData().putInt(TAG_DAMAGE, (int)damage);
                return shot;
            };
        } else if (magazineShotFactories.containsKey(magazineType)) {
            shotfactory = magazineShotFactories.get(magazineType);
        }
        if (shotfactory != null) {
            ServerLevel level2 = (ServerLevel)user.level();
            FakePlayer player2 = FakePlayerFactory.getMinecraft((ServerLevel)level2);
            player2.setPos(user.position());
            player2.setXRot(user.getXRot());
            player2.setYRot(user.getYRot());
            PotionContents potionContents = this.getPotionContents(user);
            ShotBase shot = shotfactory.createShot((Level)level2, (Player)player2, InteractionHand.MAIN_HAND).addPotionContents(potionContents);
            float motionX = -Mth.sin((float)(player2.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(player2.getXRot() / 180.0f * (float)Math.PI));
            float motionZ = Mth.cos((float)(player2.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(player2.getXRot() / 180.0f * (float)Math.PI));
            float motionY = -Mth.sin((float)(player2.getXRot() / 180.0f * (float)Math.PI));
            shot.shoot((double)motionX, (double)motionY, (double)motionZ, 1.2f, 1.0f);
            level2.addFreshEntity((Entity)shot);
            user.playSound((SoundEvent)ModSounds.HANDGUN_SHOT.get(), 0.5f, 1.2f);
        } else {
            user.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), 1.0f, 1.0f);
        }
        if (!rawMagazineType.isEmpty()) {
            this.insertItem(user, (IItemHandler)user.getInventoryCitizen(), new ItemStack((ItemLike)ModItems.EMPTY_BULLET.get()));
        }
        this.setBulletCount(user, this.getBulletCount(user) - 1);
    }

    public int getBulletCount(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).getInt("bulletCount");
    }

    public void setBulletCount(@NotNull AbstractEntityCitizen user, int count) {
        this.getOrCreateTag(user).putInt("bulletCount", Math.max(count, 0));
    }

    public String getMagazineType(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).getString("magazineType");
    }

    public void setMagazineType(@NotNull AbstractEntityCitizen user, String magazine) {
        this.getOrCreateTag(user).putString("magazineType", magazine);
    }

    public void setPotionContents(@NotNull AbstractEntityCitizen user, PotionContents contents) {
        Tag tag = Utils.serializeCodecMess((Codec)PotionContents.CODEC, (HolderLookup.Provider)user.registryAccess(), (Object)contents);
        this.getOrCreateTag(user).put("potionContents", tag);
    }

    public PotionContents getPotionContents(@NotNull AbstractEntityCitizen user) {
        CompoundTag tag = this.getOrEmptyTag(user).getCompound("potionContents");
        PotionContents contents = (PotionContents)Utils.deserializeCodecMess((Codec)PotionContents.CODEC, (HolderLookup.Provider)user.registryAccess(), (Tag)tag);
        return contents;
    }
}

