/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.regions_unexplored;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.block.leaves.AppleLeavesBlock;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class AppleLeavesFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return BuiltInRegistries.BLOCK.getKey((Object)RuBlocks.APPLE_OAK_NATURAL_SET.getLeaves());
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)RuBlocks.APPLE_OAK_NATURAL_SET.getSapling()), new ItemStack((ItemLike)RuBlocks.APPLE_OAK_NATURAL_SET.getLeaves()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)Items.APPLE));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == RuBlocks.APPLE_OAK_NATURAL_SET.getLeaves();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)AppleLeavesBlock.AGE) == 4;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            level.setBlock(context.getPosition(), (BlockState)context.getState().setValue((Property)AppleLeavesBlock.AGE, (Comparable)Integer.valueOf(0)), 2);
        }
        return Collections.singletonList(new ItemStack((ItemLike)Items.APPLE, 1));
    }
}

