/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.refinedstorage;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternListener;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.storage.root.RootStorageListener;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;

public class CitizenGridNetworkNode
extends AbstractNetworkNode {
    private final InternalListener internalListener = new InternalListener();
    private final List<ExternalListener> externalListeners = new ArrayList<ExternalListener>();

    public boolean addExternalListener(ExternalListener listener) {
        return this.externalListeners.add(listener);
    }

    public boolean removeExternalListener(ExternalListener listener) {
        return this.externalListeners.remove(listener);
    }

    public long getEnergyUsage() {
        return ((Integer)MineColoniesCompatibilityConfigServer.INSTANCE.modules.RS.citizen_grid_energyUsage.get()).intValue();
    }

    public void setNetwork(Network network) {
        AutocraftingNetworkComponent autocrafting;
        StorageNetworkComponent storage;
        if (this.network != null) {
            storage = (StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class);
            storage.removeListener((RootStorageListener)this.internalListener);
            autocrafting = (AutocraftingNetworkComponent)this.network.getComponent(AutocraftingNetworkComponent.class);
            autocrafting.removeListener((PatternListener)this.internalListener);
        }
        super.setNetwork(network);
        if (this.network != null) {
            storage = (StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class);
            storage.addListener((RootStorageListener)this.internalListener);
            autocrafting = (AutocraftingNetworkComponent)this.network.getComponent(AutocraftingNetworkComponent.class);
            autocrafting.addListener((PatternListener)this.internalListener);
        }
    }

    public class InternalListener
    implements RootStorageListener,
    PatternListener {
        public void changed(MutableResourceList.OperationResult result) {
            ResourceKey resourceKey = result.resource();
            if (resourceKey instanceof ItemResource) {
                ItemResource resource = (ItemResource)resourceKey;
                for (ExternalListener listener : CitizenGridNetworkNode.this.externalListeners) {
                    if (result.change() <= 0L) continue;
                    listener.onChanged(resource.toItemStack());
                }
            }
        }

        public void onAdded(Pattern pattern) {
            CitizenGridNetworkNode.this.externalListeners.forEach(p -> p.onAdded(pattern));
        }

        public void onRemoved(Pattern pattern) {
            CitizenGridNetworkNode.this.externalListeners.forEach(p -> p.onRemoved(pattern));
        }
    }

    public static interface ExternalListener {
        public void onChanged(ItemStack var1);

        public void onAdded(Pattern var1);

        public void onRemoved(Pattern var1);
    }
}

