/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.refinedstorage;

import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.storage.StoragePropertyTypes;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import steve_gall.minecolonies_compatibility.module.common.refinedstorage.CitizenGridBlockEntity;
import steve_gall.minecolonies_compatibility.module.common.refinedstorage.init.ModuleMenuTypes;

public class CitizenGridContainerMenu
extends AbstractBaseContainerMenu {
    private CitizenGridBlockEntity grid;
    private final Predicate<Player> stillValid;
    private final int[] linkedPos = new int[4];

    public CitizenGridContainerMenu(int windowId, Inventory playerInventory, RegistryFriendlyByteBuf data) {
        super((MenuType)ModuleMenuTypes.CITIZEN_GRID.get(), windowId);
        this.grid = null;
        this.addPlayerInventory(playerInventory, 8, 55);
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.registerProperty((Property)new ClientProperty(StoragePropertyTypes.ACCESS_MODE, (Object)AccessMode.INSERT_EXTRACT));
        this.stillValid = p -> true;
        this.addDataSlot(DataSlot.shared((int[])this.linkedPos, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.linkedPos, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.linkedPos, (int)2));
        this.addDataSlot(DataSlot.shared((int[])this.linkedPos, (int)3));
    }

    public CitizenGridContainerMenu(CitizenGridBlockEntity grid, Player player, int windowId) {
        super((MenuType)ModuleMenuTypes.CITIZEN_GRID.get(), windowId);
        this.grid = grid;
        this.addPlayerInventory(player.getInventory(), 8, 55);
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((CitizenGridBlockEntity)grid).getRedstoneMode(), arg_0 -> ((CitizenGridBlockEntity)grid).setRedstoneMode(arg_0)));
        this.registerProperty((Property)new ServerProperty(StoragePropertyTypes.ACCESS_MODE, grid::getAccessMode, grid::setAccessMode));
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)grid, (Player)p);
        this.addDataSlot(DataSlot.shared((int[])this.linkedPos, (int)0));
        this.addDataSlot(DataSlot.shared((int[])this.linkedPos, (int)1));
        this.addDataSlot(DataSlot.shared((int[])this.linkedPos, (int)2));
        this.addDataSlot(DataSlot.shared((int[])this.linkedPos, (int)3));
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.grid != null) {
            Optional<BlockPos> posWrapper = this.grid.getNetworkStorageView().getLinkedPos();
            int n = this.linkedPos[0] = posWrapper.isPresent() ? 1 : 0;
            if (posWrapper.isPresent()) {
                BlockPos pos = posWrapper.get();
                this.linkedPos[1] = pos.getX();
                this.linkedPos[2] = pos.getY();
                this.linkedPos[3] = pos.getZ();
            }
        }
    }

    public Optional<BlockPos> getLinkedPos() {
        if (this.linkedPos[0] > 0) {
            return Optional.of(new BlockPos(this.linkedPos[1], this.linkedPos[2], this.linkedPos[3]));
        }
        return Optional.empty();
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }
}

