/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.refinedstorage;

import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.network.security.SecurityActor;
import com.refinedmods.refinedstorage.api.network.security.SecurityNetworkComponent;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.security.BuiltinPermission;
import com.refinedmods.refinedstorage.common.security.PlayerSecurityActor;
import com.refinedmods.refinedstorage.common.storage.AccessModeSettings;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.block.entity.INetworkStorageViewHolder;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.QueueNetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.requestsystem.NetworkCrafting;
import steve_gall.minecolonies_compatibility.mixin.common.refinedstorage.AutocraftingNetworkComponentImplAccessor;
import steve_gall.minecolonies_compatibility.module.common.refinedstorage.CitizenGridContainerMenu;
import steve_gall.minecolonies_compatibility.module.common.refinedstorage.CitizenGridNetworkNode;
import steve_gall.minecolonies_compatibility.module.common.refinedstorage.init.ModuleBlockEntities;

public class CitizenGridBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<CitizenGridNetworkNode>
implements NetworkNodeMenuProvider,
INetworkStorageViewHolder {
    private static final String TAG_LINK = "link";
    private static final String TAG_ACCESS_MODE = "am";
    private final StorageView view;
    private final Actor actor;
    private AccessMode accessMode = AccessMode.INSERT_EXTRACT;

    public CitizenGridBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModuleBlockEntities.CITIZEN_GRID.get(), pos, state, (AbstractNetworkNode)new CitizenGridNetworkNode());
        this.view = new StorageView();
        this.actor = new NetworkNodeActor(this.mainNetworkNode);
        ((CitizenGridNetworkNode)this.mainNetworkNode).addExternalListener(this.view);
    }

    public Component getName() {
        return this.overrideName((Component)this.getBlockState().getBlock().getName());
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new CitizenGridContainerMenu(this, player, windowId);
    }

    public void doWork() {
        super.doWork();
        this.view.tick();
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.put(TAG_LINK, (Tag)this.view.writeLink());
        tag.putInt(TAG_ACCESS_MODE, AccessModeSettings.getAccessMode((AccessMode)this.accessMode));
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_LINK)) {
            this.view.readLink(tag.getCompound(TAG_LINK));
        }
        if (tag.contains(TAG_ACCESS_MODE)) {
            this.accessMode = AccessModeSettings.getAccessMode((int)tag.getInt(TAG_ACCESS_MODE));
        }
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        if (this.accessMode != accessMode) {
            this.accessMode = accessMode;
            this.setChanged();
        }
    }

    @Override
    @NotNull
    public INetworkStorageView getNetworkStorageView() {
        return this.view;
    }

    public class StorageView
    extends QueueNetworkStorageView
    implements CitizenGridNetworkNode.ExternalListener {
        private Map<IToken<?>, TaskHolder> tasks = new HashMap();
        private Queue<Pattern> patternQueue = new ArrayDeque<Pattern>();

        @Override
        public Level getLevel() {
            return CitizenGridBlockEntity.this.level;
        }

        @Override
        public BlockPos getPos() {
            return CitizenGridBlockEntity.this.worldPosition;
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return null;
        }

        @Override
        @NotNull
        public ItemStack getIcon() {
            return new ItemStack((ItemLike)CitizenGridBlockEntity.this.getBlockState().getBlock());
        }

        @Override
        public boolean isActive() {
            return ((CitizenGridNetworkNode)CitizenGridBlockEntity.this.mainNetworkNode).isActive();
        }

        @Override
        public void link(NetworkStorageModule module) {
            super.link(module);
            CitizenGridBlockEntity.this.setChanged();
        }

        @Override
        public void unlink() {
            super.unlink();
            CitizenGridBlockEntity.this.setChanged();
            this.tasks.clear();
        }

        @Override
        protected void onUnlink(NetworkStorageModule module) {
            super.onUnlink(module);
            IRequestManager requestManager = module.getBuilding().getColony().getRequestManager();
            for (IToken<?> requestId : new ArrayList(this.tasks.keySet())) {
                this.cancelAutocrafting(requestId);
                IRequest request = requestManager.getRequestForToken(requestId);
                if (request == null) continue;
                requestManager.updateRequestState(requestId, RequestState.CANCELLED);
            }
        }

        public boolean hasPermission(Permission permission) {
            NetworkStorageModule module = this.getLinkedModule();
            Network network = ((CitizenGridNetworkNode)CitizenGridBlockEntity.this.mainNetworkNode).getNetwork();
            if (module == null || network == null) {
                return false;
            }
            UUID owner = module.getBuilding().getColony().getPermissions().getOwner();
            PlayerSecurityActor actor = new PlayerSecurityActor(owner);
            return owner != null && ((SecurityNetworkComponent)network.getComponent(SecurityNetworkComponent.class)).isAllowed(permission, (SecurityActor)actor);
        }

        @Override
        public boolean canExtract() {
            return this.hasPermission((Permission)BuiltinPermission.EXTRACT) && CitizenGridBlockEntity.this.accessMode != AccessMode.INSERT;
        }

        @Override
        public boolean canInsert() {
            return this.hasPermission((Permission)BuiltinPermission.INSERT) && CitizenGridBlockEntity.this.accessMode != AccessMode.EXTRACT;
        }

        @Override
        public Stream<ItemStack> getAllStacks() {
            Network network = ((CitizenGridNetworkNode)CitizenGridBlockEntity.this.mainNetworkNode).getNetwork();
            if (network == null) {
                return Stream.empty();
            }
            Collection entryList = ((StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class)).getAll();
            return entryList.stream().filter(r -> r.resource() instanceof ItemResource).map(r -> ((ItemResource)r.resource()).toItemStack(r.amount()));
        }

        @Override
        public ItemStack extractItem(ItemStack stack, boolean simulate) {
            Network network = ((CitizenGridNetworkNode)CitizenGridBlockEntity.this.mainNetworkNode).getNetwork();
            if (network == null) {
                return ItemStack.EMPTY;
            }
            long extracted = ((StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class)).extract((ResourceKey)ItemResource.ofItemStack((ItemStack)stack), (long)stack.getCount(), simulate ? Action.SIMULATE : Action.EXECUTE, CitizenGridBlockEntity.this.actor);
            return stack.copyWithCount((int)extracted);
        }

        @Override
        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            Network network = ((CitizenGridNetworkNode)CitizenGridBlockEntity.this.mainNetworkNode).getNetwork();
            if (network == null) {
                return stack;
            }
            long inserted = ((StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class)).insert((ResourceKey)ItemResource.ofItemStack((ItemStack)stack), (long)stack.getCount(), simulate ? Action.SIMULATE : Action.EXECUTE, CitizenGridBlockEntity.this.actor);
            return stack.copyWithCount(stack.getCount() - (int)inserted);
        }

        @Override
        @NotNull
        public ItemStack calculateAutocrafting(@NotNull IDeliverable deliverable) {
            return this.findMatchedOutput(deliverable);
        }

        private ItemStack findMatchedOutput(Pattern pattern, IDeliverable deliverable) {
            for (ResourceAmount output : pattern.layout().outputs()) {
                ItemResource itemOutput;
                ItemStack stack;
                ResourceKey resourceKey = output.resource();
                if (!(resourceKey instanceof ItemResource) || !deliverable.matches(stack = (itemOutput = (ItemResource)resourceKey).toItemStack())) continue;
                return stack;
            }
            return ItemStack.EMPTY;
        }

        private ItemStack findMatchedOutput(IDeliverable deliverable) {
            Network network = ((CitizenGridNetworkNode)CitizenGridBlockEntity.this.mainNetworkNode).getNetwork();
            if (network == null) {
                return ItemStack.EMPTY;
            }
            AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
            for (Pattern pattern : autocrafting.getPatterns()) {
                ItemStack output = this.findMatchedOutput(pattern, deliverable);
                if (output.isEmpty()) continue;
                return output;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public void cancelAutocrafting(@NotNull IToken<?> requestId) {
            super.cancelAutocrafting(requestId);
            TaskHolder taskHolder = this.tasks.remove(requestId);
            if (taskHolder != null) {
                TaskId taskId;
                CitizenGridBlockEntity.this.setChanged();
                Network network = ((CitizenGridNetworkNode)CitizenGridBlockEntity.this.mainNetworkNode).getNetwork();
                if (network != null && (taskId = taskHolder.getTaskId()) != null) {
                    ((AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class)).cancel(taskId);
                }
            }
        }

        @Override
        public void createAutocrafting(@NotNull IToken<?> requestId) {
            super.createAutocrafting(requestId);
            this.tasks.put(requestId, new TaskHolder(CitizenGridBlockEntity.this));
            CitizenGridBlockEntity.this.setChanged();
        }

        @Override
        public void updateAutocraftings() {
            super.updateAutocraftings();
            NetworkStorageModule module = this.getLinkedModule();
            if (module == null) {
                return;
            }
            Network network = ((CitizenGridNetworkNode)CitizenGridBlockEntity.this.mainNetworkNode).getNetwork();
            if (network == null) {
                return;
            }
            IRequestManager requestManager = module.getBuilding().getColony().getRequestManager();
            AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
            StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
            ArrayList toRemove = new ArrayList();
            for (Map.Entry<IToken<?>, TaskHolder> entry : this.tasks.entrySet()) {
                IToken<?> requestId = entry.getKey();
                TaskHolder taskHolder = entry.getValue();
                NetworkCrafting networkCrafting = this.getNetworkCrafting(requestManager, requestId);
                IDeliverable deliverable = this.getDeliverable(requestManager, requestId);
                if (networkCrafting == null || deliverable == null) {
                    toRemove.add(requestId);
                    continue;
                }
                TaskId taskId = taskHolder.getTaskId();
                if (taskId == null) {
                    ItemResource output = ItemResource.ofItemStack((ItemStack)this.findMatchedOutput(deliverable));
                    long extracting = storage.extract((ResourceKey)output, (long)deliverable.getCount(), Action.SIMULATE, CitizenGridBlockEntity.this.actor);
                    long craftingCount = (long)deliverable.getCount() - extracting;
                    if (craftingCount <= 0L) {
                        toRemove.add(requestId);
                        continue;
                    }
                    taskId = autocrafting.startTask((ResourceKey)output, craftingCount, CitizenGridBlockEntity.this.actor, false, CancellationToken.NONE).orElse(null);
                    if (taskId != null) {
                        taskHolder.setTaskId(taskId);
                        CitizenGridBlockEntity.this.setChanged();
                        requestManager.markDirty();
                        networkCrafting.setText((Component)Component.literal((String)"CRAFTING"));
                        continue;
                    }
                    networkCrafting.setText((Component)Component.literal((String)"RESOURCE MISSING"));
                    continue;
                }
                PatternProvider provider = ((AutocraftingNetworkComponentImplAccessor)autocrafting).getProviderByTaskId().get(taskId);
                if (provider != null) continue;
                toRemove.add(requestId);
            }
            for (IToken iToken : toRemove) {
                IRequest request = requestManager.getRequestForToken(iToken);
                this.tasks.remove(iToken);
                CitizenGridBlockEntity.this.setChanged();
                if (request == null) continue;
                requestManager.updateRequestState(iToken, RequestState.CANCELLED);
                requestManager.markDirty();
            }
        }

        @Override
        protected void onActiveChanged(boolean isActive) {
            super.onActiveChanged(isActive);
            if (isActive) {
                this.requestAllPattern();
            }
        }

        @Override
        public void tick() {
            super.tick();
            NetworkStorageModule module = this.getLinkedModule();
            if (module != null) {
                Pattern pattern;
                for (int i = 0; i < 18 && (pattern = this.patternQueue.poll()) != null; ++i) {
                    IRequestManager requestManager = module.getBuilding().getColony().getRequestManager();
                    requestManager.onColonyUpdate(request -> {
                        IDeliverable deliverable;
                        IRequestable patt0$temp = request.getRequest();
                        return patt0$temp instanceof IDeliverable && !this.findMatchedOutput(pattern, deliverable = (IDeliverable)patt0$temp).isEmpty();
                    });
                }
            } else {
                this.patternQueue.clear();
            }
        }

        private void requestAllPattern() {
            this.patternQueue.clear();
            Network network = ((CitizenGridNetworkNode)CitizenGridBlockEntity.this.mainNetworkNode).getNetwork();
            if (network == null) {
                return;
            }
            AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
            this.patternQueue.addAll(autocrafting.getPatterns());
        }

        @Override
        public void onChanged(ItemStack item) {
            this.enqueue(item);
        }

        @Override
        public void onAdded(Pattern pattern) {
            this.patternQueue.add(pattern);
        }

        @Override
        public void onRemoved(Pattern pattern) {
        }
    }

    public class TaskHolder {
        private TaskId taskId;

        public TaskHolder(CitizenGridBlockEntity this$0) {
            this.taskId = null;
        }

        public TaskHolder(CitizenGridBlockEntity this$0, CompoundTag tag) {
            if (tag.hasUUID("taskId")) {
                this.taskId = new TaskId(tag.getUUID("taskId"));
            }
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            if (this.taskId != null) {
                tag.putUUID("taskId", this.taskId.id());
            }
            return tag;
        }

        public TaskId getTaskId() {
            return this.taskId;
        }

        public void setTaskId(TaskId taskId) {
            this.taskId = taskId;
        }
    }
}

