/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.minecraft;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class NetherWartFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return BuiltInRegistries.BLOCK.getKey((Object)Blocks.NETHER_WART);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)Items.NETHER_WART));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)Items.NETHER_WART));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == Blocks.NETHER_WART;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)NetherWartBlock.AGE) == 3;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        List<ItemStack> drops = context.getDrops(harvester);
        BlockState newState = (BlockState)context.getState().setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(0));
        PlantBlockContext.replant(context, drops, newState);
        return drops;
    }
}

