/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_vinery;

import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import steve_gall.minecolonies_compatibility.api.common.crafting.SimpleContainerRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.crafting.SimpleRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.module.client.lets_do_vinery.ApplePressFermentingTeachScreen;
import steve_gall.minecolonies_compatibility.module.client.lets_do_vinery.ApplePressMashingTeachScreen;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.AppleLeavesFruit;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.CherryLeavesFruit;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.GrapeFruit;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.crafting.ApplePressFermentingRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.crafting.ApplePressMashingRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.init.ModuleBuildingModules;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.init.ModuleCraftingTypes;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.init.ModuleMenuTypes;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.network.ApplePressFermentingOpenTeachMessage;
import steve_gall.minecolonies_compatibility.module.common.lets_do_vinery.network.ApplePressMashingOpenTeachMessage;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizedRecipeStorageRegistry;
import steve_gall.minecolonies_tweaks.api.common.network.MessageRegistrar;

public class LetsDoVineryModule
extends AbstractModule {
    @Override
    protected void onLoad() {
        super.onLoad();
        IEventBus fml_bus = ModLoadingContext.get().getActiveContainer().getEventBus();
        ModuleCraftingTypes.REGISTER.register(fml_bus);
        ModuleMenuTypes.REGISTER.register(fml_bus);
        CustomizedRecipeStorageRegistry.INSTANCE.register(ApplePressMashingRecipeStorage.ID, SimpleRecipeStorage::serialize, ApplePressMashingRecipeStorage::new);
        CustomizedRecipeStorageRegistry.INSTANCE.register(ApplePressFermentingRecipeStorage.ID, SimpleContainerRecipeStorage::serialize, ApplePressFermentingRecipeStorage::new);
    }

    @Override
    protected void onRegisterNetwork(MessageRegistrar channel) {
        super.onRegisterNetwork(channel);
        channel.playToServer(ApplePressMashingOpenTeachMessage.TYPE, ApplePressMashingOpenTeachMessage::new);
        channel.playToServer(ApplePressFermentingOpenTeachMessage.TYPE, ApplePressFermentingOpenTeachMessage::new);
    }

    @Override
    protected void onInitBuildingModule() {
        super.onInitBuildingModule();
        ((BuildingEntry)ModBuildings.farmer.get()).getModuleProducers().add(ModuleBuildingModules.FARMER_APPLE_PRESS_MASHING);
        ((BuildingEntry)ModBuildings.farmer.get()).getModuleProducers().add(ModuleBuildingModules.FARMER_APPLE_PRESS_FERMENTING);
    }

    @Override
    protected void onFMLCommonSetup(FMLCommonSetupEvent e) {
        super.onFMLCommonSetup(e);
        e.enqueueWork(() -> {
            CustomizedFruit.register(new AppleLeavesFruit());
            CustomizedFruit.register(new CherryLeavesFruit());
            for (GrapeType grapeType : GrapeTypeRegistry.GRAPE_TYPE_TYPES) {
                Item patt0$temp = grapeType.getSeeds();
                if (!(patt0$temp instanceof BlockItem)) continue;
                BlockItem item = (BlockItem)patt0$temp;
                CustomizedFruit.register(new GrapeFruit(grapeType, item.getBlock()));
            }
        });
    }

    @Override
    protected void onRegisterMenuScreens(RegisterMenuScreensEvent e) {
        super.onRegisterMenuScreens(e);
        e.register((MenuType)ModuleMenuTypes.APPLE_PRESS_MASHING.get(), ApplePressMashingTeachScreen::new);
        e.register((MenuType)ModuleMenuTypes.APPLE_PRESS_FERMENTING.get(), ApplePressFermentingTeachScreen::new);
    }
}

