/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_vinery;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.block.GrapeBush;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class GrapeFruit
extends CustomizedFruit {
    private final GrapeType grapeType;
    private final Block block;

    public GrapeFruit(GrapeType grapeType, Block block) {
        this.grapeType = grapeType;
        this.block = block;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return BuiltInRegistries.BLOCK.getKey((Object)this.block);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.grapeType.getSeeds()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.grapeType.getFruit()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == this.block;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)GrapeBush.AGE) > 1;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)GrapeBush.AGE) == 3;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            BlockState newState = (BlockState)state.setValue((Property)GrapeBush.AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(context.getPosition(), newState, 2);
            Integer i = (Integer)state.getValue((Property)GrapeBush.AGE);
            boolean bl = i == 3;
            int x = level.random.nextInt(2);
            Item item = this.grapeType.getFruit();
            return Collections.singletonList(new ItemStack((ItemLike)item, x + (bl ? 1 : 0)));
        }
        return Collections.emptyList();
    }
}

