/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_vinery;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.block.DarkCherryLeavesBlock;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class CherryLeavesFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return ObjectRegistry.DARK_CHERRY_LEAVES.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)ObjectRegistry.DARK_CHERRY_SAPLING.get()), new ItemStack((ItemLike)ObjectRegistry.DARK_CHERRY_LEAVES.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)ObjectRegistry.CHERRY.get()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == ObjectRegistry.DARK_CHERRY_LEAVES.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        return (Boolean)state.getValue((Property)DarkCherryLeavesBlock.CAN_GROW_CHERRIES) != false && (Boolean)state.getValue((Property)DarkCherryLeavesBlock.HAS_CHERRIES) != false;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            RandomSource random = level.getRandom();
            int dropCount = random.nextBoolean() ? random.nextInt(1, 4) : 1;
            ItemStack dropStack = new ItemStack((ItemLike)ObjectRegistry.CHERRY.get(), dropCount);
            BlockState newState = (BlockState)context.getState().setValue((Property)DarkCherryLeavesBlock.HAS_CHERRIES, (Comparable)Boolean.valueOf(false));
            level.setBlockAndUpdate(context.getPosition(), newState);
            return Collections.singletonList(dropStack);
        }
        return Collections.emptyList();
    }
}

