/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.lets_do_vinery;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.block.AppleLeavesBlock;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class AppleLeavesFruit
extends CustomizedFruit {
    @Override
    @NotNull
    public ResourceLocation getId() {
        return ObjectRegistry.APPLE_LEAVES.getId();
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)ObjectRegistry.APPLE_TREE_SAPLING.get()), new ItemStack((ItemLike)ObjectRegistry.APPLE_LEAVES.get()));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)Items.APPLE));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == ObjectRegistry.APPLE_LEAVES.get();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        return (Boolean)state.getValue((Property)AppleLeavesBlock.CAN_GROW_APPLES) != false && (Boolean)state.getValue((Property)AppleLeavesBlock.HAS_APPLES) != false;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            RandomSource random = level.getRandom();
            int dropCount = random.nextBoolean() ? random.nextInt(1, 4) : 1;
            ItemStack dropStack = new ItemStack((ItemLike)Items.APPLE, dropCount);
            BlockState newState = (BlockState)context.getState().setValue((Property)AppleLeavesBlock.HAS_APPLES, (Comparable)Boolean.valueOf(false));
            level.setBlockAndUpdate(context.getPosition(), newState);
            return Collections.singletonList(dropStack);
        }
        return Collections.emptyList();
    }
}

