/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.menu;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.inventory.IMenuRecipeValidator;
import steve_gall.minecolonies_compatibility.api.common.inventory.MenuRecipeValidatorRecipe;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachContainer;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachInputSlot;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachResultSlot;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleMenuTypes;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CookingTeachMenu
extends TeachRecipeMenu<RecipeHolder<CookingPotRecipe>, RecipeWrapper> {
    public static final int INVENTORY_X = 8;
    public static final int INVENTORY_Y = 84;
    public static final int CRAFTING_SLOTS = 6;
    public static final int CRAFTING_COLS = 3;
    public static final int CRAFTING_X = 26;
    public static final int CRAFTING_Y = 17;
    public static final int RESULT_X = 130;
    public static final int RESULT_Y = 30;
    public static final int CONTAINER_X = 88;
    public static final int CONTAINER_Y = 45;

    public CookingTeachMenu(int windowId, Inventory inventory, IBuildingModule module) {
        super((MenuType)ModuleMenuTypes.COOKING_TEACH.get(), windowId, inventory, module);
        this.setup();
    }

    public CookingTeachMenu(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        super((MenuType)ModuleMenuTypes.COOKING_TEACH.get(), windowId, inventory, buffer);
        this.setup();
    }

    private void setup() {
        this.addInventorySlots(8, 84);
        this.inputContainer = new TeachContainer(this, 6);
        for (int i = 0; i < 6; ++i) {
            int col = i % 3;
            int row = i / 3;
            this.inputSlots.add(this.addSlot(new TeachInputSlot(this.inputContainer, i, 26 + col * 18, 17 + row * 18)));
        }
        this.resultContainer = new TeachContainer(this, 2);
        this.resultSlots.add(this.addSlot(new TeachResultSlot(this.resultContainer, 0, 130, 30)));
        this.resultSlots.add(this.addSlot(new TeachResultSlot(this.resultContainer, 1, 88, 45)));
    }

    @Override
    protected IMenuRecipeValidator<RecipeHolder<CookingPotRecipe>, RecipeWrapper> createRecipeValidator() {
        return new MenuRecipeValidatorRecipe<CookingPotRecipe, RecipeWrapper>(this, this.inventory.player.level()){

            @Override
            public RecipeType<CookingPotRecipe> getRecipeType() {
                return (RecipeType)ModRecipeTypes.COOKING.get();
            }

            @Override
            @NotNull
            public RecipeWrapper getInput(@NotNull Container container, @NotNull RecipeHolder<CookingPotRecipe> recipe) {
                return new RecipeWrapper((IItemHandler)new InvWrapper(container));
            }
        };
    }

    @Override
    protected void setContainerByTransfer(@NotNull HolderLookup.Provider provider, @NotNull RecipeHolder<CookingPotRecipe> recipe, @NotNull CompoundTag payload) {
        super.setContainerByTransfer(provider, recipe, payload);
        List input = NBTUtils2.deserializeList(payload, "input", ItemSerializationHelper.deserializerTag((HolderLookup.Provider)provider));
        for (int i = 0; i < 6; ++i) {
            this.inputContainer.setItem(i, i < input.size() ? (ItemStack)input.get(i) : ItemStack.EMPTY);
        }
    }

    @Override
    protected void onRecipeChanged(HolderLookup.Provider provider, RecipeWrapper input) {
        this.resultContainer.setItem(0, this.recipe != null ? ((CookingPotRecipe)((RecipeHolder)this.recipe).value()).getResultItem(provider) : ItemStack.EMPTY);
        this.resultContainer.setItem(1, this.recipe != null ? ((CookingPotRecipe)((RecipeHolder)this.recipe).value()).getOutputContainer() : ItemStack.EMPTY);
    }
}

