/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.crafting.ISecondaryRollableRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.PlatingGenericRecipe;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class PlatingRecipeStorage
extends GenericedRecipeStorage<PlatingGenericRecipe>
implements ISecondaryRollableRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("farmerdelight_plating");
    private final Block block;
    private final List<ItemStorage> ingredients;
    private final ItemStack container;
    private final ItemStack output;
    private final PlatingGenericRecipe recipe;

    public static void serialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag, PlatingRecipeStorage recipe) {
        tag.putString("block", BuiltInRegistries.BLOCK.getKey((Object)recipe.block).toString());
    }

    public static PlatingRecipeStorage deserialize(HolderLookup.Provider provider, IFactoryController controller, CompoundTag tag) {
        ResourceLocation blockId = ResourceLocation.parse((String)tag.getString("block"));
        Block block = (Block)BuiltInRegistries.BLOCK.get(blockId);
        return new PlatingRecipeStorage(block);
    }

    private PlatingRecipeStorage(Block block) {
        this.block = block;
        ArrayList<ItemStorage> ingredients = new ArrayList<ItemStorage>();
        ItemStack container = ItemStack.EMPTY;
        ItemStack output = ItemStack.EMPTY;
        if (block instanceof FeastBlock) {
            FeastBlock feastBlock = (FeastBlock)block;
            BlockState state = feastBlock.defaultBlockState();
            int maxServings = feastBlock.getMaxServings();
            ingredients.add(new ItemStorage(new ItemStack((ItemLike)block)));
            for (int i = 0; i < maxServings; ++i) {
                state = (BlockState)state.setValue((Property)feastBlock.getServingsProperty(), (Comparable)Integer.valueOf(maxServings - i));
                ItemStack servingItem = feastBlock.getServingItem(state);
                if (!output.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)servingItem)) {
                    output = ItemStack.EMPTY;
                    container = ItemStack.EMPTY;
                    break;
                }
                if (output.isEmpty()) {
                    output = servingItem.copy();
                } else {
                    output.setCount(output.getCount() + servingItem.getCount());
                }
                if (!servingItem.hasCraftingRemainingItem()) continue;
                ItemStack containerItem = servingItem.getCraftingRemainingItem();
                if (!container.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)container, (ItemStack)containerItem)) {
                    output = ItemStack.EMPTY;
                    container = ItemStack.EMPTY;
                    break;
                }
                if (container.isEmpty()) {
                    container = containerItem.copy();
                    continue;
                }
                container.setCount(container.getCount() + containerItem.getCount());
            }
        }
        if (!container.isEmpty()) {
            ingredients.add(new ItemStorage(container.copyWithCount(1), container.getCount()));
        }
        this.ingredients = ingredients;
        this.container = container;
        this.output = output;
        this.recipe = new PlatingGenericRecipe(this);
    }

    public PlatingRecipeStorage(FeastBlock block) {
        this((Block)block);
    }

    @Override
    @NotNull
    public List<ItemStack> rollSecondaryOutputs(@NotNull LootParams context) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Block block = this.block;
        if (block instanceof FeastBlock) {
            FeastBlock feastBlock = (FeastBlock)block;
            BlockState state = (BlockState)feastBlock.defaultBlockState().setValue((Property)feastBlock.getServingsProperty(), (Comparable)Integer.valueOf(0));
            return Block.getDrops((BlockState)state, (ServerLevel)context.getLevel(), (BlockPos)BlockPos.ZERO, null);
        }
        return list;
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PlatingRecipeStorage) {
            PlatingRecipeStorage other = (PlatingRecipeStorage)o;
            return this.block == other.block;
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public Block getBlock() {
        return this.block;
    }

    public List<ItemStorage> getInput() {
        return this.ingredients;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public ItemStack getPrimaryOutput() {
        return this.output;
    }

    @Override
    public PlatingGenericRecipe getGenericRecipe() {
        return this.recipe;
    }
}

