/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;

public class MushroomColonyFruit
extends CustomizedFruit {
    private final MushroomColonyBlock block;

    public MushroomColonyFruit(MushroomColonyBlock block) {
        this.block = block;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return BuiltInRegistries.BLOCK.getKey((Object)this.block);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.block));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(this.block.getCloneItemStack(null, null, null));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() == this.getBlock();
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().getValue((Property)MushroomColonyBlock.COLONY_AGE) > 0;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return ((Integer)context.getState().getValue((Property)MushroomColonyBlock.COLONY_AGE)).intValue() == this.block.getMaxAge();
    }

    @Override
    @NotNull
    public SoundEvent getHarvestSound(@NotNull PlantBlockContext context) {
        return SoundEvents.MOOSHROOM_SHEAR;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof LevelWriter) {
            LevelWriter level = (LevelWriter)levelReader;
            BlockState state = context.getState();
            Integer age = (Integer)state.getValue((Property)MushroomColonyBlock.COLONY_AGE);
            level.setBlock(context.getPosition(), (BlockState)state.setValue((Property)MushroomColonyBlock.COLONY_AGE, (Comparable)Integer.valueOf(age - 1)), 2);
        }
        return Collections.singletonList(this.block.getCloneItemStack(context.getLevel(), context.getPosition(), context.getState()));
    }

    public MushroomColonyBlock getBlock() {
        return this.block;
    }
}

