/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight;

import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import steve_gall.minecolonies_compatibility.api.common.crafting.SimpleContainerRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.event.AnimalHerdingLootEvent;
import steve_gall.minecolonies_compatibility.api.common.event.AnimalHerdingToolEvent;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedCrop;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;
import steve_gall.minecolonies_compatibility.module.client.farmersdelight.CookingTeachScreen;
import steve_gall.minecolonies_compatibility.module.client.farmersdelight.CuttingTeachScreen;
import steve_gall.minecolonies_compatibility.module.client.farmersdelight.PlatingTeachScreen;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.MushroomColonyFruit;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.RiceFruit;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.TomatoCrop;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CookingRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.PlatingRecipeStorage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleBuildingModules;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleCraftingTypes;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.init.ModuleMenuTypes;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.network.CookingOpenTeachMessage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.network.CuttingOpenTeachMessage;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.network.PlatingOpenTeachMessage;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizedRecipeStorageRegistry;
import steve_gall.minecolonies_tweaks.api.common.network.MessageRegistrar;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.registry.ModItems;

public class FarmersDelightModule
extends AbstractModule {
    @Override
    protected void onLoad() {
        super.onLoad();
        IEventBus fml_bus = ModLoadingContext.get().getActiveContainer().getEventBus();
        ModuleCraftingTypes.REGISTER.register(fml_bus);
        ModuleMenuTypes.REGISTER.register(fml_bus);
        IEventBus forge_bus = NeoForge.EVENT_BUS;
        forge_bus.addListener(this::onAnimalHerdingTool);
        forge_bus.addListener(this::onAnimalHerdingLoot);
        CustomizedRecipeStorageRegistry.INSTANCE.register(CuttingRecipeStorage.ID, CuttingRecipeStorage::serialize, CuttingRecipeStorage::deserialize);
        CustomizedRecipeStorageRegistry.INSTANCE.register(CookingRecipeStorage.ID, SimpleContainerRecipeStorage::serialize, CookingRecipeStorage::new);
        CustomizedRecipeStorageRegistry.INSTANCE.register(PlatingRecipeStorage.ID, PlatingRecipeStorage::serialize, PlatingRecipeStorage::deserialize);
    }

    @Override
    protected void onInitBuildingModule() {
        super.onInitBuildingModule();
        ((BuildingEntry)ModBuildings.kitchen.get()).getModuleProducers().add(ModuleBuildingModules.CHEF_CUTTING);
        ((BuildingEntry)ModBuildings.kitchen.get()).getModuleProducers().add(ModuleBuildingModules.CHEF_COOKING);
        ((BuildingEntry)ModBuildings.kitchen.get()).getModuleProducers().add(ModuleBuildingModules.CHEF_PLATING);
        ((BuildingEntry)ModBuildings.lumberjack.get()).getModuleProducers().add(ModuleBuildingModules.LUMBERJACK_CUTTING);
        ((BuildingEntry)ModBuildings.stoneMason.get()).getModuleProducers().add(ModuleBuildingModules.STONEMASON_CUTTING);
    }

    @Override
    protected void onFMLCommonSetup(FMLCommonSetupEvent e) {
        super.onFMLCommonSetup(e);
        e.enqueueWork(() -> {
            CustomizedCrop.register(new TomatoCrop());
            for (Block block : BuiltInRegistries.BLOCK) {
                if (!(block instanceof MushroomColonyBlock)) continue;
                MushroomColonyBlock mushroomColony = (MushroomColonyBlock)block;
                CustomizedFruit.register(new MushroomColonyFruit(mushroomColony));
            }
            CustomizedFruit.register(new RiceFruit());
        });
    }

    @Override
    protected void onRegisterMenuScreens(RegisterMenuScreensEvent e) {
        super.onRegisterMenuScreens(e);
        e.register((MenuType)ModuleMenuTypes.CUTTING_TEACH.get(), CuttingTeachScreen::new);
        e.register((MenuType)ModuleMenuTypes.COOKING_TEACH.get(), CookingTeachScreen::new);
        e.register((MenuType)ModuleMenuTypes.PLATING_TEACH.get(), PlatingTeachScreen::new);
    }

    @Override
    protected void onRegisterNetwork(MessageRegistrar channel) {
        super.onRegisterNetwork(channel);
        channel.playToServer(CuttingOpenTeachMessage.TYPE, CuttingOpenTeachMessage::new);
        channel.playToServer(CookingOpenTeachMessage.TYPE, CookingOpenTeachMessage::new);
        channel.playToServer(PlatingOpenTeachMessage.TYPE, PlatingOpenTeachMessage::new);
    }

    private void onAnimalHerdingTool(AnimalHerdingToolEvent e) {
        EntityType type = e.getAnimal().getType();
        if (type == EntityType.PIG || type == EntityType.HOGLIN) {
            e.register(ModToolTypes.KNIFE.getToolType());
        }
    }

    private void onAnimalHerdingLoot(AnimalHerdingLootEvent e) {
        EntityType<?> type = e.getRecipe().getRequiredEntity();
        if ((type == EntityType.PIG || type == EntityType.HOGLIN) && e.getRecipe().getRequiredTool() == ModToolTypes.KNIFE.getToolType()) {
            e.register(new LootTableAnalyzer.LootDrop(Collections.singletonList(new ItemStack((ItemLike)ModItems.HAM.get())), 0.5f, 1.0f, false));
        }
    }

    public static List<Component> getChanceTooltip(float chance) {
        if (chance != 1.0f) {
            return Collections.singletonList(FarmersDelightModule.createChanceTooltip(chance));
        }
        return Collections.emptyList();
    }

    public static Component createChanceTooltip(float chance) {
        return Component.translatable((String)"farmersdelight.jei.chance", (Object[])new Object[]{(double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))}).withStyle(ChatFormatting.GOLD);
    }
}

