/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.cobblemon;

import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.block.entity.BerryBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.mixin.common.cobblemon.BerryBlockAccessor;

public class BerryFruit
extends CustomizedFruit {
    private final BerryBlock block;

    public BerryFruit(BerryBlock block) {
        this.block = block;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return BuiltInRegistries.BLOCK.getKey((Object)this.block);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.block));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.block));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().getBlock() instanceof BerryBlock;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        return ((BerryBlockAccessor)state.getBlock()).invokeIsMaxAage(state);
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        ServerLevel level;
        BlockState state = context.getState();
        BlockPos position = context.getPosition();
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel && (levelReader = (level = (ServerLevel)levelReader).getBlockEntity(position)) instanceof BerryBlockEntity) {
            BerryBlockEntity blockEntity = (BerryBlockEntity)levelReader;
            FakePlayer player = FakePlayerFactory.getMinecraft((ServerLevel)level);
            return new ArrayList<ItemStack>(blockEntity.harvest((Level)level, state, position, (Player)player));
        }
        return Collections.emptyList();
    }
}

