/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.ae2;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.IStackWatcher;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageWatcherNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigManagerBuilder;
import appeng.api.util.IConfigurableObject;
import appeng.items.parts.PartModels;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractDisplayPart;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.QueueNetworkStorageView;
import steve_gall.minecolonies_compatibility.module.common.ae2.CableBusBlockEntityExtension;
import steve_gall.minecolonies_compatibility.module.common.ae2.init.ModuleMenuTypes;

public class CitizenTerminalPart
extends AbstractDisplayPart
implements IStorageWatcherNode,
IGridTickable,
IConfigurableObject {
    @PartModels
    public static final ResourceLocation MODEL_OFF = MineColoniesCompatibility.rl("part/citizen_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = MineColoniesCompatibility.rl("part/citizen_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    private static final String TAG_LINK = "link";
    private final StorageView view = new StorageView();
    private final KeyCounter counter = new KeyCounter();
    private final IActionSource action = IActionSource.ofMachine((IActionHost)this);
    private final IConfigManager config;

    public CitizenTerminalPart(IPartItem<?> partItem) {
        super(partItem, false);
        IConfigManagerBuilder builder = IConfigManager.builder(this::onSettingChanged);
        builder.registerSetting(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.config = builder.build();
        IManagedGridNode mainNode = this.getMainNode();
        mainNode.addService(IStorageWatcherNode.class, (IGridNodeService)this);
        mainNode.addService(IGridTickable.class, (IGridNodeService)this);
    }

    protected void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.getHost().markForSave();
    }

    public boolean hasPermission() {
        NetworkStorageModule module = this.view.getLinkedModule();
        IGrid grid = this.getMainNode().getGrid();
        return module != null && grid != null;
    }

    public void removeFromWorld() {
        CableBusBlockEntityExtension cableBus;
        super.removeFromWorld();
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof CableBusBlockEntityExtension && !(cableBus = (CableBusBlockEntityExtension)blockEntity).minecolonies_compatibility$isChunkUnloaded()) {
            this.view.unlink();
        }
    }

    public boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (!super.onUseWithoutItem(player, pos) && !this.isClientSide()) {
            MenuOpener.open((MenuType)((MenuType)ModuleMenuTypes.CITIZEN_TERMINAL.get()), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 1, false, 1);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.view.tick();
        return TickRateModulation.SAME;
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        if (newWatcher != null) {
            newWatcher.reset();
            newWatcher.setWatchAll(true);
            this.counter.clear();
            this.getMainNode().ifPresent(grid -> {
                KeyCounter original = grid.getStorageService().getCachedInventory();
                for (Object2LongMap.Entry entry : original) {
                    Object patt0$temp = entry.getKey();
                    if (!(patt0$temp instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)patt0$temp;
                    this.counter.add((AEKey)itemKey, entry.getLongValue());
                }
            });
        }
    }

    public static ItemStack toStack(Object2LongMap.Entry<AEKey> entry) {
        return CitizenTerminalPart.toStack((AEItemKey)entry.getKey(), entry.getLongValue());
    }

    public static ItemStack toStack(AEItemKey key, long amount) {
        return key.toStack((int)Math.min(Integer.MAX_VALUE, amount));
    }

    public void onStackChange(AEKey what, long amount) {
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            this.getMainNode().ifPresent(grid -> {
                long prev = this.counter.get((AEKey)itemKey);
                this.counter.set((AEKey)itemKey, amount);
                if (prev < amount) {
                    this.view.enqueue(CitizenTerminalPart.toStack(itemKey, amount));
                }
            });
        }
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.view.readLink(data.getCompound(TAG_LINK));
        this.config.readFromNBT(data.getCompound("config"), registries);
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.put(TAG_LINK, (Tag)this.view.writeLink());
        CompoundTag configTag = new CompoundTag();
        this.config.writeToNBT(configTag, registries);
        data.put("config", (Tag)configTag);
    }

    public boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean needRedraw = super.readFromStream(data);
        boolean changed = this.view.readLink(data);
        return needRedraw || changed;
    }

    public void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        this.view.writeLink(data);
    }

    @NotNull
    public INetworkStorageView getView() {
        return this.view;
    }

    public IConfigManager getConfigManager() {
        return this.config;
    }

    public class StorageView
    extends QueueNetworkStorageView {
        @Override
        public Level getLevel() {
            return CitizenTerminalPart.this.getLevel();
        }

        @Override
        public BlockPos getPos() {
            return CitizenTerminalPart.this.getBlockEntity().getBlockPos();
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return CitizenTerminalPart.this.getSide();
        }

        @Override
        @NotNull
        public ItemStack getIcon() {
            return new ItemStack((ItemLike)CitizenTerminalPart.this.getPartItem());
        }

        @Override
        public boolean isActive() {
            return CitizenTerminalPart.this.isActive();
        }

        @Override
        public void link(NetworkStorageModule module) {
            super.link(module);
            IPartHost host = CitizenTerminalPart.this.getHost();
            if (host != null) {
                host.markForSave();
                host.markForUpdate();
            }
        }

        @Override
        public void unlink() {
            super.unlink();
            IPartHost host = CitizenTerminalPart.this.getHost();
            if (host != null) {
                host.markForSave();
                host.markForUpdate();
            }
        }

        @Override
        public boolean canExtract() {
            return CitizenTerminalPart.this.hasPermission() && ((AccessRestriction)CitizenTerminalPart.this.config.getSetting(Settings.ACCESS)).isAllowExtraction();
        }

        @Override
        public boolean canInsert() {
            return CitizenTerminalPart.this.hasPermission() && ((AccessRestriction)CitizenTerminalPart.this.config.getSetting(Settings.ACCESS)).isAllowInsertion();
        }

        @Override
        public Stream<ItemStack> getAllStacks() {
            return StreamSupport.stream(CitizenTerminalPart.this.counter.spliterator(), false).map(CitizenTerminalPart::toStack);
        }

        @Override
        public ItemStack extractItem(ItemStack stack, boolean simulate) {
            IGrid grid = CitizenTerminalPart.this.getMainNode().getGrid();
            if (grid == null) {
                return ItemStack.EMPTY;
            }
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            MEStorage network = grid.getStorageService().getInventory();
            int extractingCount = (int)network.extract((AEKey)key, (long)stack.getCount(), Actionable.ofSimulate((boolean)simulate), CitizenTerminalPart.this.action);
            if (extractingCount == 0) {
                return ItemStack.EMPTY;
            }
            return key.toStack(extractingCount);
        }

        @Override
        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            IGrid grid = CitizenTerminalPart.this.getMainNode().getGrid();
            if (grid == null) {
                return ItemStack.EMPTY;
            }
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            MEStorage network = grid.getStorageService().getInventory();
            int insertedCount = (int)network.insert((AEKey)key, (long)stack.getCount(), Actionable.ofSimulate((boolean)simulate), CitizenTerminalPart.this.action);
            if (insertedCount == 0) {
                return stack;
            }
            stack = stack.copy();
            stack.shrink(insertedCount);
            return stack;
        }
    }
}

