/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common;

import java.util.function.Supplier;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import steve_gall.minecolonies_compatibility.module.common.AbstractModule;
import steve_gall.minecolonies_tweaks.api.common.building.module.ModuleRegisterEvent;
import steve_gall.minecolonies_tweaks.api.common.network.MessageRegistrar;

public class OptionalModule<MODULE extends AbstractModule> {
    private final String modId;
    private final Supplier<Supplier<MODULE>> initializer;
    private boolean isLoaded;
    private MODULE module;

    public OptionalModule(String modid, Supplier<Supplier<MODULE>> initializer) {
        this.modId = modid;
        this.initializer = initializer;
        this.isLoaded = false;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean isInstalled() {
        return ModList.get().isLoaded(this.getModId());
    }

    protected boolean canLoad() {
        return this.isInstalled();
    }

    public void tryLoad() {
        if (this.canLoad()) {
            this.isLoaded = true;
            this.module = (AbstractModule)this.initializer.get().get();
            ((AbstractModule)this.module).onLoad();
            IEventBus fml_bus = ModLoadingContext.get().getActiveContainer().getEventBus();
            fml_bus.addListener(this::onModuleRegister);
            fml_bus.addListener(arg_0 -> this.module.onFMLCommonSetup(arg_0));
            fml_bus.addListener(arg_0 -> this.module.onFMLClientSetup(arg_0));
            fml_bus.addListener(arg_0 -> this.module.onRegisterMenuScreens(arg_0));
        }
    }

    private void onModuleRegister(ModuleRegisterEvent e) {
        ((AbstractModule)this.module).onInitBuildingModule();
    }

    public void onRegisterNetwork(MessageRegistrar channel) {
        ((AbstractModule)this.module).onRegisterNetwork(channel);
    }

    public void onRecipeReloaded(RecipeManager recipeManager) {
        ((AbstractModule)this.module).onRecipeReloaded(recipeManager);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public MODULE getModule() {
        return this.module;
    }
}

