/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.client.jei;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.requirements.BuildingAlternatesResearchRequirement;
import com.minecolonies.api.research.requirements.BuildingResearchRequirement;
import com.minecolonies.api.research.requirements.ResearchResearchRequirement;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.module.client.jei.ModJeiRecipeTypes;

public class ResearchCategory
implements IRecipeCategory<ResearchCache> {
    public static final Component TITLE = Component.translatable((String)"com.minecolonies.coremod.research.research");
    public static final ResourceLocation TEXTURE = MineColoniesCompatibility.rl("textures/jei/research.png");
    private final IDrawable background;
    private final IDrawable slot;

    public ResearchCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 176, 63);
        this.slot = guiHelper.getSlotDrawable();
    }

    public RecipeType<ResearchCache> getRecipeType() {
        return ModJeiRecipeTypes.RESEARCH;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ResearchCache cache, IFocusGroup focuses) {
        int requirementIndex = 0;
        for (Tuple<IResearchRequirement, List<ItemStack>> tuple : cache.requirements) {
            int xi = requirementIndex % 9;
            int yi = requirementIndex / 9;
            IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 8 + 18 * xi, 22 + 18 * yi);
            slotBuilder.setBackground(this.slot, -1, -1);
            slotBuilder.addItemStacks((List)tuple.getB());
            slotBuilder.addTooltipCallback((recipeSlotView, tooltip) -> {
                tooltip.clear();
                tooltip.add(((IResearchRequirement)tuple.getA()).getDesc());
            });
            ++requirementIndex;
        }
        List<List<ItemStack>> costs = cache.costs;
        for (int i = 0; i < costs.size(); ++i) {
            List<ItemStack> cost = costs.get(i);
            int xi = i % 9;
            int yi = i / 9;
            IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 8 + 18 * xi, 45 + 18 * yi);
            slotBuilder.setBackground(this.slot, -1, -1);
            slotBuilder.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, cost);
        }
    }

    public List<Component> getTooltipStrings(ResearchCache cache, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        if (0.0 <= mouseY) {
            Objects.requireNonNull(font);
            if (mouseY <= (double)(10.0f + 9.0f)) {
                return cache.tooltip;
            }
        }
        return Collections.emptyList();
    }

    public void draw(ResearchCache cache, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        graphics.drawString(font, cache.header, 0, 0, -16777216, false);
        graphics.drawString(font, cache.name, 0, 10, -16777216, false);
    }

    public static class ResearchCache {
        public final IGlobalResearch research;
        public final Component header;
        public final Component name;
        public final List<Component> effects;
        public final List<Tuple<IResearchRequirement, List<ItemStack>>> requirements;
        public final List<List<ItemStack>> costs;
        public final List<Component> tooltip;

        public ResearchCache(IGlobalResearch research) {
            IGlobalResearchBranch branch = MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getBranchData(research.getBranch());
            int depth = research.getDepth();
            int shosingDepth = depth > 5 ? 5 : depth;
            MutableComponent level = Component.translatable((String)"com.minecolonies.coremod.gui.research.tier.header", (Object[])new Object[]{shosingDepth, branch.getHoursTime(depth)});
            this.research = research;
            this.header = MutableComponent.create((ComponentContents)branch.getName()).append(" - ").append((Component)level);
            this.name = MutableComponent.create((ComponentContents)research.getName());
            this.effects = research.getEffects().stream().map(effect -> MutableComponent.create((ComponentContents)effect.getName())).toList();
            this.requirements = research.getResearchRequirements().stream().map(requirement -> new Tuple(requirement, this.getDisplayItemStacks((IResearchRequirement)requirement).toList())).toList();
            this.costs = research.getCostList().stream().map(cost -> Arrays.asList(cost.getItems())).toList();
            this.tooltip = new ArrayList<Component>();
            this.tooltip.add(this.header);
            this.tooltip.add((Component)Component.empty().append(this.name).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD));
            this.tooltip.addAll(this.effects);
            Style style = Style.EMPTY.withColor(ResearchConstants.COLOR_TEXT_UNFULFILLED);
            for (IResearchRequirement requirement2 : research.getResearchRequirements()) {
                this.tooltip.add((Component)Component.literal((String)" - ").append((Component)requirement2.getDesc()).withStyle(style));
            }
            for (SizedIngredient cost2 : research.getCostList()) {
                this.tooltip.add((Component)Component.literal((String)" - ").append((Component)Component.translatable((String)"com.minecolonies.coremod.research.limit.cost", (Object[])new Object[]{ItemStackUtils.getTranslatedName((SizedIngredient)cost2)})).withStyle(style));
            }
        }

        private ItemLike getBuildingItem(ResourceLocation buildingName) {
            Registry buildingRegistry = IMinecoloniesAPI.getInstance().getBuildingRegistry();
            if (buildingRegistry.containsKey(buildingName)) {
                return ((BuildingEntry)buildingRegistry.get(buildingName)).getBuildingBlock();
            }
            return Items.AIR;
        }

        private Stream<ItemStack> getDisplayItemStacks(IResearchRequirement requirement) {
            if (requirement instanceof BuildingAlternatesResearchRequirement) {
                BuildingAlternatesResearchRequirement alternateBuildingRequirement = (BuildingAlternatesResearchRequirement)requirement;
                return alternateBuildingRequirement.getBuildings().stream().map(name -> new ItemStack(this.getBuildingItem((ResourceLocation)name), alternateBuildingRequirement.getBuildingLevel()));
            }
            if (requirement instanceof BuildingResearchRequirement) {
                BuildingResearchRequirement buildingRequirement = (BuildingResearchRequirement)requirement;
                return Stream.of(new ItemStack(this.getBuildingItem(buildingRequirement.getBuilding()), buildingRequirement.getBuildingLevel()));
            }
            if (requirement instanceof ResearchResearchRequirement) {
                return Stream.of(new ItemStack((ItemLike)Items.BOOK, 1));
            }
            return Stream.empty();
        }
    }
}

