/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.mixin.common.minecolonies;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractAISkeleton;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIBasic;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAI;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAIContext;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.ICustomizableEntityAI;
import steve_gall.minecolonies_compatibility.core.common.colony.CitizenHelper;
import steve_gall.minecolonies_compatibility.core.common.entity.AbstractEntityAIBasicExtension;

@Mixin(value={AbstractEntityAIBasic.class}, remap=false)
public abstract class AbstractEntityAIBasicMixin<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractAISkeleton<J>
implements AbstractEntityAIBasicExtension {
    @Shadow(remap=false)
    private int slotAt;
    @Unique
    private CustomizedAI minecolonies_compatibility$selectedAI = null;
    @Unique
    private int minecolonies_compatibility$lastSlot = -1;
    @Unique
    private Item minecolonies_compatibility$lastItem = null;

    protected AbstractEntityAIBasicMixin(@NotNull J job) {
        super(job);
    }

    private void updateAI(ICustomizableEntityAI self) {
        AbstractEntityCitizen worker = this.worker;
        int toolSlot = CitizenHelper.getMaxLevelToolSlot(worker.getCitizenData(), self.getHandToolType());
        CustomizedAIContext context = new CustomizedAIContext(worker, toolSlot);
        this.minecolonies_compatibility$selectedAI = toolSlot == -1 ? null : CustomizedAI.select(context);
        this.minecolonies_compatibility$lastSlot = toolSlot;
        this.minecolonies_compatibility$lastItem = worker.getInventoryCitizen().getStackInSlot(toolSlot).getItem();
        if (this.minecolonies_compatibility$selectedAI != null) {
            CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.worker, (InteractionHand)InteractionHand.MAIN_HAND, (int)toolSlot);
            this.minecolonies_compatibility$selectedAI.onSelected(worker);
        } else {
            CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.worker, (InteractionHand)InteractionHand.MAIN_HAND, (int)-1);
        }
    }

    @WrapOperation(method={"dumpOneMoreSlot"}, remap=false, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", remap=true)})
    private boolean dumpOneMoreSlot_isEmpty(ItemStack stackToDump, Operation<Boolean> operation) {
        ICustomizableEntityAI self;
        CustomizedAI ai;
        if (((Boolean)operation.call(new Object[]{stackToDump})).booleanValue()) {
            return true;
        }
        AbstractEntityAIBasicMixin abstractEntityAIBasicMixin = this;
        if (abstractEntityAIBasicMixin instanceof ICustomizableEntityAI && (ai = (self = (ICustomizableEntityAI)((Object)abstractEntityAIBasicMixin)).getSelectedAI()) != null) {
            if (this.slotAt == ai.getMainHandSlot(this.worker)) {
                return true;
            }
            if (!ai.canDump(this.worker, this.slotAt, stackToDump)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CustomizedAI minecolonies_compatibility$getSelectedAI() {
        AbstractEntityAIBasicMixin abstractEntityAIBasicMixin = this;
        if (abstractEntityAIBasicMixin instanceof ICustomizableEntityAI) {
            ICustomizableEntityAI self = (ICustomizableEntityAI)((Object)abstractEntityAIBasicMixin);
            if (this.needUpdateAI()) {
                this.updateAI(self);
            } else {
                CitizenItemUtils.setHeldItem((AbstractEntityCitizen)this.worker, (InteractionHand)InteractionHand.MAIN_HAND, (int)this.minecolonies_compatibility$lastSlot);
            }
            return this.minecolonies_compatibility$selectedAI;
        }
        return null;
    }

    private boolean needUpdateAI() {
        int slot = this.minecolonies_compatibility$lastSlot;
        if (slot == -1) {
            return true;
        }
        return this.worker.getInventoryCitizen().getStackInSlot(slot).getItem() != this.minecolonies_compatibility$lastItem;
    }
}

