/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.requestsystem;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractBuildingDependentRequestResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;
import steve_gall.minecolonies_compatibility.core.common.requestsystem.NetworkCrafting;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableRequestable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IRequestableObject;

public class NetworkCraftingRequestResolver
extends AbstractBuildingDependentRequestResolver<IDeliverable> {
    private static final TypeToken<IDeliverable> REQUEST_TYPE = TypeToken.of(IDeliverable.class);

    public static NetworkCraftingRequestResolver deserialize(ILocation location, IToken<?> token, CompoundTag compound) {
        return new NetworkCraftingRequestResolver(location, token);
    }

    public static void serialize(NetworkCraftingRequestResolver resolver, CompoundTag compound) {
    }

    public NetworkCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    public TypeToken<? extends IDeliverable> getRequestType() {
        return REQUEST_TYPE;
    }

    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        if (!manager.getColony().getWorld().isClientSide()) {
            return Optional.ofNullable(manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation()));
        }
        return Optional.empty();
    }

    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends IDeliverable> request) {
        if (manager.getColony().getWorld().isClientSide()) {
            return false;
        }
        IBuilding building = (IBuilding)manager.getColony().getServerBuildingManager().getBuilding(this.getLocation().getInDimensionLocation());
        if (building == null) {
            return false;
        }
        NetworkStorageModule module = (NetworkStorageModule)building.getModule(ModBuildingModules.NETWORK_STORAGE);
        if (module == null) {
            return false;
        }
        IDeliverable deliverable = (IDeliverable)request.getRequest();
        for (INetworkStorageView view : module.getRequestableBlocks().toList()) {
            ItemStack calculated = view.calculateAutocrafting(deliverable);
            if (calculated.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public int getPriority() {
        return 125;
    }

    public boolean canResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        return true;
    }

    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        CustomizableRequestable cr;
        IRequestable iRequestable = request.getRequest();
        if (iRequestable instanceof CustomizableRequestable && (cr = (CustomizableRequestable)iRequestable).getObject() instanceof NetworkCrafting) {
            if (manager.getColony().getWorld().isClientSide()) {
                return;
            }
            IBuilding building = (IBuilding)manager.getColony().getServerBuildingManager().getBuilding(this.getLocation().getInDimensionLocation());
            if (building == null) {
                return;
            }
            NetworkStorageModule module = (NetworkStorageModule)building.getModule(ModBuildingModules.NETWORK_STORAGE);
            if (module == null) {
                return;
            }
            for (INetworkStorageView view : module.getBlocks().toList()) {
                view.cancelAutocrafting(request.getId());
            }
        }
    }

    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        if (manager.getColony().getWorld().isClientSide()) {
            return null;
        }
        NetworkStorageModule module = (NetworkStorageModule)building.getModule(ModBuildingModules.NETWORK_STORAGE);
        if (module == null) {
            return null;
        }
        IDeliverable deliverable = (IDeliverable)request.getRequest();
        for (INetworkStorageView view : module.getRequestableBlocks().toList()) {
            ItemStack calculated = view.calculateAutocrafting(deliverable);
            if (calculated.isEmpty()) continue;
            NetworkCrafting networkCrafting = new NetworkCrafting();
            networkCrafting.setCycles((deliverable.getCount() + calculated.getCount() - 1) / calculated.getCount());
            networkCrafting.setItem(calculated);
            networkCrafting.setView(view.getIcon());
            networkCrafting.setText((Component)Component.literal((String)"READY"));
            IToken child = manager.createRequest((IRequester)this, (IRequestable)new CustomizableRequestable((IRequestableObject)networkCrafting));
            view.createAutocrafting(child);
            return Arrays.asList(child);
        }
        return null;
    }

    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        manager.updateRequestState(request.getId(), RequestState.RESOLVED);
    }

    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        NetworkCrafting networkCrafting;
        ItemStack view;
        CustomizableRequestable cr;
        IRequestable iRequestable = request.getRequest();
        if (iRequestable instanceof CustomizableRequestable && (iRequestable = (cr = (CustomizableRequestable)iRequestable).getObject()) instanceof NetworkCrafting && !(view = (networkCrafting = (NetworkCrafting)iRequestable).getView()).isEmpty()) {
            return view.getHoverName().copy();
        }
        return super.getRequesterDisplayName(manager, request);
    }
}

