/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.requestsystem;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractBuildingDependentRequestResolver;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.requestsystem.NetworkCrafting;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.ICustomizableRequestable;

public class NetworkCraftingProductionResolver
extends AbstractBuildingDependentRequestResolver<ICustomizableRequestable> {
    private static final TypeToken<ICustomizableRequestable> REQUEST_TYPE = TypeToken.of(ICustomizableRequestable.class);

    public static NetworkCraftingProductionResolver deserialize(ILocation location, IToken<?> token, CompoundTag compound) {
        return new NetworkCraftingProductionResolver(location, token);
    }

    public static void serialize(NetworkCraftingProductionResolver resolver, CompoundTag compound) {
    }

    public NetworkCraftingProductionResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    public TypeToken<? extends ICustomizableRequestable> getRequestType() {
        return REQUEST_TYPE;
    }

    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        if (!manager.getColony().getWorld().isClientSide()) {
            return Optional.ofNullable(manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation()));
        }
        return Optional.empty();
    }

    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends ICustomizableRequestable> request) {
        if (manager.getColony().getWorld().isClientSide()) {
            return false;
        }
        return ((ICustomizableRequestable)request.getRequest()).getObject() instanceof NetworkCrafting && request.getRequester().getLocation().equals((Object)this.getLocation());
    }

    public int getPriority() {
        return 100;
    }

    public boolean canResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends ICustomizableRequestable> request, @NotNull AbstractBuilding building) {
        return true;
    }

    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends ICustomizableRequestable> request) {
    }

    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends ICustomizableRequestable> request) {
    }

    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends ICustomizableRequestable> request, @NotNull AbstractBuilding building) {
        if (manager.getColony().getWorld().isClientSide()) {
            return null;
        }
        return Collections.emptyList();
    }

    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends ICustomizableRequestable> request, @NotNull AbstractBuilding building) {
    }

    public void onColonyUpdate(@NotNull IRequestManager manager, @NotNull Predicate<IRequest<?>> shouldTriggerReassign) {
        super.onColonyUpdate(manager, shouldTriggerReassign);
    }
}

