/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.requestsystem;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IRequestableObject;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class NetworkCrafting
implements IRequestableObject {
    private static final Component EMPTY = Component.empty();
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("network_crafting");
    public static final Component DISPLAY_STRING = Component.translatable((String)"minecolonies_compatibility.request.network_crafting");
    public static final ResourceLocation ICON = MineColoniesCompatibility.rl("textures/gui/citizen/network_crafting.png");
    private int cycles;
    private ItemStack item = ItemStack.EMPTY;
    private ItemStack view = ItemStack.EMPTY;
    private Component text = EMPTY;

    public static NetworkCrafting deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag tag) {
        NetworkCrafting crafting = new NetworkCrafting();
        crafting.cycles = tag.getInt("cycles");
        crafting.item = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("item"));
        crafting.view = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("view"));
        crafting.text = Component.Serializer.fromJson((String)tag.getString("text"), (HolderLookup.Provider)provider);
        return crafting;
    }

    public static void serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag tag, @NotNull NetworkCrafting request) {
        tag.putInt("cycles", request.cycles);
        tag.put("item", (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)request.item));
        tag.put("view", (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)request.view));
        tag.putString("text", Component.Serializer.toJson((Component)request.text, (HolderLookup.Provider)provider));
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public Component getShortDisplayString() {
        return Component.translatable((String)"%s * %s", (Object[])new Object[]{this.cycles, DISPLAY_STRING});
    }

    @NotNull
    public Component getLongDisplayString() {
        if (!this.view.isEmpty()) {
            return Component.translatable((String)"%s * %s - %s: %s", (Object[])new Object[]{this.cycles, DISPLAY_STRING, this.view.getHoverName(), this.getText()});
        }
        return DISPLAY_STRING;
    }

    @NotNull
    public List<ItemStack> getDisplayStacks() {
        if (!this.item.isEmpty()) {
            return Collections.singletonList(this.item);
        }
        return Collections.emptyList();
    }

    @NotNull
    public List<MutableComponent> getResolverToolTip(@NotNull IColonyView colony) {
        return super.getResolverToolTip(colony);
    }

    @NotNull
    public ResourceLocation getDisplayIcon() {
        return ICON;
    }

    public void setCycles(int cycles) {
        this.cycles = cycles;
    }

    public int getCycles() {
        return this.cycles;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setView(ItemStack view) {
        this.view = view;
    }

    public ItemStack getView() {
        return this.view;
    }

    public void setText(Component text) {
        this.text = text;
    }

    public Component getText() {
        return this.text;
    }
}

