/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Utils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_compatibility.api.common.building.module.IRestrictableModule;
import steve_gall.minecolonies_compatibility.api.common.building.module.IRestrictableModuleView;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.init.ModItems;
import steve_gall.minecolonies_compatibility.core.common.item.RestrictToolItem;
import steve_gall.minecolonies_compatibility.core.common.network.message.BuildingModuleMessage;

public class RestrictGiveToolMessage
extends BuildingModuleMessage {
    public static final CustomPacketPayload.Type<RestrictGiveToolMessage> TYPE = new CustomPacketPayload.Type(MineColoniesCompatibility.rl("restrict_give_tool"));
    private final Component moduleDesc;

    public RestrictGiveToolMessage(IRestrictableModuleView module, Component moduleDesc) {
        super(module);
        this.moduleDesc = moduleDesc;
    }

    public RestrictGiveToolMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.moduleDesc = (Component)Utils.deserializeCodecMess((StreamCodec)ComponentSerialization.STREAM_CODEC, (RegistryFriendlyByteBuf)buffer);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        Utils.serializeCodecMess((StreamCodec)ComponentSerialization.STREAM_CODEC, (RegistryFriendlyByteBuf)buffer, (Object)this.moduleDesc);
    }

    public void handle(IPayloadContext context) {
        super.handle(context);
        IBuildingModule iBuildingModule = this.getModule();
        if (iBuildingModule instanceof IRestrictableModule) {
            IRestrictableModule module = (IRestrictableModule)iBuildingModule;
            RestrictToolItem item = (RestrictToolItem)((Object)ModItems.RESTRICT_TOOL.get());
            Player player = context.player();
            ItemStack tool = InventoryUtils.getOrCreateItemAndPutToHotbarAndSelectOrDrop((Item)item, (Player)player, () -> ((RestrictToolItem)item).getDefaultInstance(), (boolean)true);
            item.setModule(tool, module, this.moduleDesc);
            player.getInventory().setChanged();
        }
    }

    public CustomPacketPayload.Type<RestrictGiveToolMessage> type() {
        return TYPE;
    }

    public Component getModuleDesc() {
        return this.moduleDesc;
    }
}

