/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.network.message;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import steve_gall.minecolonies_compatibility.api.common.building.module.IMenuBuildingModuleView;
import steve_gall.minecolonies_compatibility.core.common.network.message.BuildingModuleMessage;

public abstract class ModuleMenuOpenMessage
extends BuildingModuleMessage {
    protected final Component desc;

    public ModuleMenuOpenMessage(IBuildingModuleView module) {
        super(module);
        if (module instanceof IMenuBuildingModuleView) {
            IMenuBuildingModuleView menuBuilding = (IMenuBuildingModuleView)module;
            this.desc = menuBuilding.getMenuDesc();
        } else if (module instanceof CraftingModuleView) {
            CraftingModuleView craftingModule = (CraftingModuleView)module;
            String id = craftingModule.getId();
            this.desc = Component.translatable((String)("com.minecolonies.coremod.gui.workerhuts.recipe." + id + ".menu"));
        } else {
            this.desc = module.getDesc();
        }
    }

    public ModuleMenuOpenMessage(RegistryFriendlyByteBuf buffer) {
        super(buffer);
        this.desc = (Component)Utils.deserializeCodecMess((StreamCodec)ComponentSerialization.STREAM_CODEC, (RegistryFriendlyByteBuf)buffer);
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buffer) {
        super.encode(buffer);
        Utils.serializeCodecMess((StreamCodec)ComponentSerialization.STREAM_CODEC, (RegistryFriendlyByteBuf)buffer, (Object)this.desc);
    }

    public void handle(IPayloadContext context) {
        super.handle(context);
        Player player = context.player();
        final IBuildingModule module = this.getModule();
        if (module == null) {
            return;
        }
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return ModuleMenuOpenMessage.this.getDisplayName();
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                return ModuleMenuOpenMessage.this.createMenu(windowId, inventory, player, module);
            }
        }, buffer -> this.toBuffer((RegistryFriendlyByteBuf)buffer, module));
    }

    protected Component getDisplayName() {
        return this.desc;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2, Player var3, IBuildingModule var4);

    protected void toBuffer(RegistryFriendlyByteBuf buffer, IBuildingModule module) {
        this.getModulePos().serializeBuffer((FriendlyByteBuf)buffer);
    }
}

