/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.item;

import java.util.Objects;
import net.minecraft.world.item.ItemStack;

public class ItemStackKey {
    private final ItemStack stack;
    private final int hashCode;

    public ItemStackKey(ItemStack stack) {
        this.stack = stack.copy();
        this.hashCode = Objects.hash(stack.getItem(), stack.getComponents().toString());
    }

    public String toString() {
        return this.stack.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemStackKey)) return false;
        ItemStackKey other = (ItemStackKey)obj;
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.stack)) return false;
        return true;
    }

    public ItemStack getStack(int count) {
        ItemStack stack = this.stack.copy();
        stack.setCount(count);
        return stack;
    }

    public ItemStack getStack(long count) {
        return this.getStack((int)Math.min(count, Integer.MAX_VALUE));
    }
}

