/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.item;

import com.minecolonies.api.util.Utils;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackKey;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;

public class ItemStackCounter {
    private final Object2LongMap<ItemStackKey> counter = new Object2LongOpenHashMap();
    private final List<CountChangedListener> listeners = new ArrayList<CountChangedListener>();

    public void deserializeTag(HolderLookup.Provider provider, CompoundTag tag) {
        this.replace(NBTUtils2.deserializeList(tag, "counter", t -> {
            ItemStack stack = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)t.getCompound("item"));
            long count = t.getLong("count");
            return new AbstractObject2LongMap.BasicEntry((Object)new ItemStackKey(stack), count);
        }));
    }

    public CompoundTag serializeTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        NBTUtils2.serializeCollection(tag, "counter", this.entrySet(), entry -> {
            CompoundTag t = new CompoundTag();
            t.put("item", (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)((ItemStackKey)entry.getKey()).getStack(1)));
            t.putLong("count", entry.getLongValue());
            return t;
        });
        return tag;
    }

    public void deserializeBuffer(RegistryFriendlyByteBuf buffer) {
        this.replace(buffer.readList(b -> {
            ItemStack stack = Utils.deserializeCodecMess((RegistryFriendlyByteBuf)buffer);
            long count = b.readLong();
            return new AbstractObject2LongMap.BasicEntry((Object)new ItemStackKey(stack), count);
        }));
    }

    public void serializeBuffer(RegistryFriendlyByteBuf buffer) {
        buffer.writeCollection(this.entrySet(), (b, entry) -> {
            Utils.serializeCodecMess((RegistryFriendlyByteBuf)buffer, (ItemStack)((ItemStackKey)entry.getKey()).getStack(1));
            b.writeLong(entry.getLongValue());
        });
    }

    public void replace(Iterable<Object2LongMap.Entry<ItemStackKey>> from) {
        HashSet<ItemStackKey> prevKeys = new HashSet<ItemStackKey>((Collection<ItemStackKey>)this.keySet());
        for (Object2LongMap.Entry<ItemStackKey> entry : from) {
            ItemStackKey key2 = (ItemStackKey)entry.getKey();
            this.set(key2, entry.getLongValue());
            prevKeys.remove(key2);
        }
        prevKeys.forEach(key -> this.set((ItemStackKey)key, 0L));
    }

    public long get(ItemStack key) {
        return this.get(new ItemStackKey(key));
    }

    public long get(ItemStackKey key) {
        return this.counter.getOrDefault((Object)key, 0L);
    }

    public long set(ItemStack key, long count) {
        return this.set(new ItemStackKey(key), count);
    }

    public long set(ItemStackKey key, long count) {
        long old;
        long l2 = old = (count = Math.max(0L, count)) <= 0L ? this.counter.removeLong((Object)key) : this.counter.put((Object)key, count);
        if (old != count) {
            long c = count;
            this.listeners.forEach(l -> l.onItemCountChanged(key, old, c));
        }
        return old;
    }

    public long extract(ItemStack key) {
        return this.extract(key, (long)key.getCount());
    }

    public long extract(ItemStack key, long count) {
        return this.extract(new ItemStackKey(key), count);
    }

    public long extract(ItemStackKey key, long count) {
        long old = this.get(key);
        return this.set(key, old - count);
    }

    public long insert(ItemStack key) {
        return this.insert(key, (long)key.getCount());
    }

    public long insert(ItemStack key, long count) {
        return this.insert(new ItemStackKey(key), count);
    }

    public long insert(ItemStackKey key, long count) {
        long old = this.get(key);
        return this.set(key, old + count);
    }

    public ObjectSet<ItemStackKey> keySet() {
        return this.counter.keySet();
    }

    public ObjectSet<Object2LongMap.Entry<ItemStackKey>> entrySet() {
        return this.counter.object2LongEntrySet();
    }

    public void addListener(CountChangedListener listener) {
        this.listeners.add(listener);
    }

    @FunctionalInterface
    public static interface CountChangedListener {
        public void onItemCountChanged(ItemStackKey var1, long var2, long var4);
    }
}

