/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.inventory;

import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class InventoryHelper {
    public static int removeStacksFromItemHandler(@NotNull IItemHandler inventory, int count, @NotNull Predicate<ItemStack> predicate) {
        int remainedCount = Math.max(count, 0);
        for (int i = 0; remainedCount > 0 && i < inventory.getSlots(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            if (!predicate.test(item)) continue;
            int reduce = Math.min(remainedCount, item.getCount());
            item.shrink(reduce);
            remainedCount -= reduce;
        }
        return remainedCount;
    }

    private InventoryHelper() {
    }
}

