/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai.orchardist;

import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.BlockPosUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class Fruit {
    public static String TAG_POSITION = "position";
    @NotNull
    private BlockPos position;
    @Nullable
    private PlantBlockContext context;
    @Nullable
    private CustomizedFruit fruit;

    public static Fruit deserialize(@NotNull CompoundTag tag) {
        Fruit fruit = new Fruit();
        fruit.position = BlockPosUtil.read((CompoundTag)tag, (String)TAG_POSITION);
        return fruit;
    }

    private Fruit() {
    }

    public Fruit(@NotNull BlockPos position) {
        this.position = position;
    }

    public void serialize(@NotNull CompoundTag tag) {
        BlockPosUtil.write((CompoundTag)tag, (String)TAG_POSITION, (BlockPos)this.position);
    }

    private void update(LevelReader level) {
        BlockPos position = this.getPosition();
        this.context = new PlantBlockContext(level, position, level.getBlockState(position));
    }

    public boolean updateAndIsValid(@NotNull LevelReader level) {
        this.update(level);
        PlantBlockContext context = this.getContext();
        CustomizedFruit fruit = this.getFruit();
        if (fruit != null && fruit.test(context)) {
            return true;
        }
        this.fruit = CustomizedFruit.select(context);
        return this.fruit != null;
    }

    public boolean canHarvest(boolean needMaxHarvest) {
        CustomizedFruit fruit = this.fruit;
        if (fruit == null) {
            return false;
        }
        PlantBlockContext context = this.getContext();
        if (!fruit.canHarvest(context)) {
            return false;
        }
        return !needMaxHarvest || fruit.isMaxHarvest(context);
    }

    public EquipmentTypeEntry getToolType() {
        CustomizedFruit fruit = this.fruit;
        return fruit != null ? fruit.getHarvestToolType(this.getContext()) : (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    public SoundEvent getSound() {
        CustomizedFruit fruit = this.fruit;
        return fruit != null ? fruit.getHarvestSound(this.getContext()) : SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES;
    }

    public List<ItemStack> harvest(@NotNull HarvesterContext harvester) {
        CustomizedFruit fruit = this.fruit;
        if (fruit != null) {
            return fruit.harvest(this.getContext(), harvester);
        }
        return Collections.emptyList();
    }

    @NotNull
    public BlockPos getPosition() {
        return this.position;
    }

    @Nullable
    public PlantBlockContext getContext() {
        return this.context;
    }

    @Nullable
    public CustomizedFruit getFruit() {
        return this.fruit;
    }
}

