/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.entity.ai;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AttackDelayConfig {
    public final ModConfigSpec.IntValue base;
    public final ModConfigSpec.DoubleValue decreasePerSkillLevel;
    public final ModConfigSpec.DoubleValue decreasePerBuildingLevel;

    public AttackDelayConfig(ModConfigSpec.Builder builder, DefaultValues defaultValues) {
        this.base = builder.defineInRange("base", defaultValues.base(), 10, 200);
        this.decreasePerSkillLevel = builder.defineInRange("decreasePerSkillLevel", defaultValues.decreasePerSkillLevel(), 0.0, 200.0);
        this.decreasePerBuildingLevel = builder.defineInRange("decreasePerBuildingLevel", defaultValues.decreasePerBuildingLevel(), 0.0, 200.0);
    }

    public int apply(AbstractEntityCitizen user, int skillLevel) {
        IBuilding building = user.getCitizenData().getWorkBuilding();
        double delay = ((Integer)this.base.get()).doubleValue();
        delay -= (Double)this.decreasePerSkillLevel.get() * (double)skillLevel;
        return (int)(delay -= (Double)this.decreasePerBuildingLevel.get() * (double)(building != null ? building.getBuildingLevel() - 1 : 0));
    }

    public static class DefaultValues {
        private int base;
        private double decreasePerSkillLevel;
        private double decreasePerBuildingLevel;

        public int base() {
            return this.base;
        }

        public DefaultValues base(int base) {
            this.base = base;
            return this;
        }

        public double decreasePerSkillLevel() {
            return this.decreasePerSkillLevel;
        }

        public DefaultValues decreasePerSkillLevel(double decreasePerSkillLevel) {
            this.decreasePerSkillLevel = decreasePerSkillLevel;
            return this;
        }

        public double decreasePerBuildingLevel() {
            return this.decreasePerBuildingLevel;
        }

        public DefaultValues decreasePerBuildingLevel(double decreasePerBuildingLevel) {
            this.decreasePerBuildingLevel = decreasePerBuildingLevel;
            return this;
        }
    }
}

