/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalHerdingLootGenericRecipe
implements IGenericRecipe {
    private final EntityType<?> entityType;
    private final ResourceLocation entityTypeKey;
    private final ResourceKey<LootTable> lootTable;
    private final List<List<ItemStack>> breedingItems;
    private final EquipmentTypeEntry toolType;

    public AnimalHerdingLootGenericRecipe(EntityType<?> entityType, List<List<ItemStorage>> breedingItems, ResourceKey<LootTable> lootTable, EquipmentTypeEntry toolType) {
        this.entityType = entityType;
        this.entityTypeKey = BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
        this.lootTable = lootTable;
        this.breedingItems = breedingItems.stream().map(l -> l.stream().map(ItemStorage::getItemStack).toList()).toList();
        this.toolType = toolType;
    }

    public int getGridSize() {
        return 0;
    }

    @Nullable
    public ResourceLocation getRecipeId() {
        return this.entityTypeKey;
    }

    @NotNull
    public ItemStack getPrimaryOutput() {
        return ItemStack.EMPTY;
    }

    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return Collections.emptyList();
    }

    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return Collections.emptyList();
    }

    @NotNull
    public List<List<ItemStack>> getInputs() {
        return this.breedingItems;
    }

    public Optional<Boolean> matchesOutput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    public Optional<Boolean> matchesInput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    @NotNull
    public Block getIntermediate() {
        return Blocks.AIR;
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    @NotNull
    public EquipmentTypeEntry getRequiredTool() {
        return this.toolType;
    }

    @Nullable
    public EntityType<?> getRequiredEntity() {
        return this.entityType;
    }

    @NotNull
    public Supplier<List<Component>> getRestrictions() {
        return Collections::emptyList;
    }

    public int getLevelSort() {
        return 0;
    }
}

