/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.AbstractModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.api.common.building.module.NetworkStorageViewRegistry;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.requestsystem.NetworkCraftingProductionResolver;
import steve_gall.minecolonies_compatibility.core.common.requestsystem.NetworkCraftingRequestResolver;
import steve_gall.minecolonies_compatibility.core.common.util.StreamUtils;

public class NetworkStorageModule
extends AbstractModuleWithExternalWorkingBlocks
implements IBuildingEventsModule,
ICreatesResolversModule {
    public static final String TAG_POSTION_DIRECTIONS = MineColoniesCompatibility.rl("position_directions").toString();
    private static final List<Direction> VIEW_DIRECTIONS = new ArrayList<Direction>();
    private boolean isDestroyed = false;
    private final Map<BlockPos, Direction> directions = new HashMap<BlockPos, Direction>();

    public List<IRequestResolver<?>> createResolvers() {
        ILocation location = this.getBuilding().getLocation();
        IFactoryController factoryController = this.getBuilding().getColony().getRequestManager().getFactoryController();
        return Arrays.asList(new IRequestResolver[]{new NetworkCraftingRequestResolver(location, (IToken)factoryController.getNewInstance(TypeConstants.ITOKEN)), new NetworkCraftingProductionResolver(location, (IToken)factoryController.getNewInstance(TypeConstants.ITOKEN))});
    }

    public void onItemIncremented(ItemStack stack) {
        this.getBuilding().getColony().getRequestManager().onColonyUpdate(request -> this.testDeliverable((IRequest<?>)request, stack));
    }

    private boolean testDeliverable(IRequest<?> request, ItemStack stack) {
        IDeliverable deliverable;
        IRequestable iRequestable = request.getRequest();
        return iRequestable instanceof IDeliverable && (deliverable = (IDeliverable)iRequestable).matches(stack);
    }

    @Override
    public boolean isWorkingBlock(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        if (this.containsWorkingBlock(pos)) {
            return this.getOwnLinkedViews(pos).findAny().isPresent();
        }
        return NetworkStorageModule.getUnlinkedView(level, pos) != null;
    }

    public Stream<INetworkStorageView> getBlocks() {
        return this.getRegisteredBlocks().stream().flatMap(this::getOwnLinkedViews);
    }

    public Stream<INetworkStorageView> getRequestableBlocks() {
        return this.getBlocks().filter(m -> NetworkStorageModule.canRequestable(m));
    }

    public static boolean canRequestable(@Nullable INetworkStorageView view) {
        return view != null && view.isActive() && view.canRequest();
    }

    public Stream<INetworkStorageView> getExtractableBlocks() {
        return this.getBlocks().filter(m -> NetworkStorageModule.canExtract(m));
    }

    public static boolean canExtract(@Nullable INetworkStorageView view) {
        return view != null && view.isActive() && view.canExtract();
    }

    public Stream<INetworkStorageView> getInsertableBlocks() {
        return this.getBlocks().filter(m -> NetworkStorageModule.canInsert(m));
    }

    public static boolean canInsert(@Nullable INetworkStorageView view) {
        return view != null && view.isActive() && view.canInsert();
    }

    public int getMatchingItemStackCount(ItemStack itemStack, int count, boolean ignoreNBT, boolean ignoreDamage, int leftOver) {
        return this.getMatchingItemStackCount(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)itemStack, (ItemStack)stack, (!ignoreDamage ? 1 : 0) != 0, (!ignoreNBT ? 1 : 0) != 0), count, leftOver);
    }

    public int getMatchingItemStackCount(Predicate<ItemStack> predicate, int count, int leftOver) {
        int totalCountFound = 0 - leftOver;
        for (ItemStack stack : StreamUtils.toIterable(this.getExtractableBlocks().flatMap(view -> view.getAllStacks().filter(predicate)))) {
            if ((totalCountFound += stack.getCount()) < count) continue;
            return totalCountFound;
        }
        return totalCountFound;
    }

    public boolean hasMatchingItemStack(ItemStack itemStack, int count, boolean ignoreNBT, boolean ignoreDamage, int leftOver) {
        return this.getMatchingItemStackCount(itemStack, count, ignoreNBT, ignoreDamage, leftOver) >= count;
    }

    public List<Tuple<ItemStack, BlockPos>> getMatchingItemStacks(Predicate<ItemStack> predicate, int limit) {
        ArrayList<Tuple<ItemStack, BlockPos>> list = new ArrayList<Tuple<ItemStack, BlockPos>>();
        int remained = limit;
        block0: for (INetworkStorageView view : StreamUtils.toIterable(this.getExtractableBlocks())) {
            for (ItemStack stack : StreamUtils.toIterable(view.getAllStacks().filter(predicate))) {
                if (remained <= 0) continue block0;
                for (ItemStack splited : this.split(stack, remained)) {
                    list.add((Tuple<ItemStack, BlockPos>)new Tuple((Object)splited, (Object)view.getPos()));
                    remained -= splited.getCount();
                }
            }
        }
        return list;
    }

    private List<ItemStack> split(ItemStack stack, int limit) {
        int count;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int maxStackSize = stack.getMaxStackSize();
        for (count = Math.min(stack.getCount(), limit); count > maxStackSize; count -= maxStackSize) {
            list.add(stack.copyWithCount(maxStackSize));
        }
        list.add(stack.copyWithCount(count));
        return list;
    }

    public void dump(IItemHandlerModifiable itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            for (INetworkStorageView view : StreamUtils.toIterable(this.getInsertableBlocks())) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemStack remained = view.insertItem(stack.copy(), false);
                itemHandler.setStackInSlot(i, remained);
            }
        }
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        ListTag directionsTag = compound.getList(TAG_POSTION_DIRECTIONS, 10);
        this.directions.clear();
        for (int i = 0; i < directionsTag.size(); ++i) {
            CompoundTag entryTag = directionsTag.getCompound(i);
            BlockPos pos = NBTUtils.readBlockPos((CompoundTag)entryTag, (String)"pos");
            String direction = entryTag.getString("direction");
            this.directions.put(pos, Direction.byName((String)direction));
        }
    }

    @Override
    public void serializeNBT(HolderLookup.Provider provider, CompoundTag compound) {
        super.serializeNBT(provider, compound);
        ListTag directionsTag = new ListTag();
        compound.put(TAG_POSTION_DIRECTIONS, (Tag)directionsTag);
        for (Map.Entry<BlockPos, Direction> entry : this.directions.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.put("pos", NBTUtils.writeBlockPos((BlockPos)entry.getKey()));
            entryTag.putString("direction", entry.getValue().getSerializedName());
            directionsTag.add((Object)entryTag);
        }
    }

    public void serializeToView(RegistryFriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeCollection(this.getWorkingBlocks().toList(), FriendlyByteBuf::writeBlockPos);
        buf.writeCollection(this.directions.entrySet(), (buf2, data) -> {
            buf2.writeBlockPos((BlockPos)data.getKey());
            buf2.writeEnum((Enum)data.getValue());
        });
    }

    public void onLink(INetworkStorageView view) {
        this.addWorkingBlock(view.getPos());
        Direction direction = view.getDirection();
        if (direction != null) {
            this.directions.put(view.getPos(), direction);
        }
    }

    public void onUnlink(INetworkStorageView view) {
        this.removeWorkingBlock(view.getPos());
        this.directions.remove(view.getPos());
    }

    @Override
    @Nullable
    protected AbstractEntityCitizen getPathFindingCitizen() {
        Set citizens = this.building.getAllAssignedCitizen();
        return citizens.stream().findAny().flatMap(ICitizenData::getEntity).orElse(null);
    }

    @Override
    protected void onWorkingBlockAdded(@NotNull BlockPos pos) {
        super.onWorkingBlockAdded(pos);
        this.link(pos);
    }

    @Override
    protected void onWorkingBlockRemoved(@Nullable BlockPos pos) {
        super.onWorkingBlockRemoved(pos);
        this.unlink(pos);
    }

    @Nullable
    public Stream<INetworkStorageView> getOwnLinkedViews(BlockPos pos) {
        Level level = this.building.getColony().getWorld();
        return NetworkStorageModule.getAllViews((LevelReader)level, pos, view -> view.getLinkedModule() == this);
    }

    private void link(BlockPos pos) {
        Level level = this.building.getColony().getWorld();
        INetworkStorageView view = NetworkStorageModule.getUnlinkedView((LevelReader)level, pos);
        if (view != null) {
            view.link(this);
        }
    }

    private void unlink(BlockPos pos) {
        this.getOwnLinkedViews(pos).forEach(view -> view.unlink());
    }

    public static Stream<INetworkStorageView> getAllViews(LevelReader level, BlockPos pos, Predicate<INetworkStorageView> predicate) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return Stream.empty();
        }
        return VIEW_DIRECTIONS.stream().map(direction -> NetworkStorageViewRegistry.select(blockEntity, direction)).filter(view -> view != null && (predicate == null || predicate.test((INetworkStorageView)view)));
    }

    @Nullable
    public static INetworkStorageView getUnlinkedView(LevelReader level, BlockPos pos) {
        return NetworkStorageModule.getAllViews(level, pos, view -> view.getLinkedModule() == null).findAny().orElse(null);
    }

    public void onDestroyed() {
        this.isDestroyed = true;
        this.getRegisteredBlocks().forEach(this::unlink);
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    static {
        VIEW_DIRECTIONS.add(null);
        VIEW_DIRECTIONS.addAll(Arrays.asList(Direction.values()));
    }
}

