/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.BlockPosUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModuleView;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;
import steve_gall.minecolonies_compatibility.core.common.requestsystem.NetworkCrafting;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableRequestable;

public abstract class AbstractNetworkStorageView
implements INetworkStorageView {
    private static final String TAG_COLONY_ID = "colonyId";
    private static final String TAG_WAREHOUSE_POS = "warehousePos";
    private int colonyId = 0;
    private Optional<BlockPos> warehousePos = Optional.empty();
    private NetworkStorageModule module = null;
    private boolean wasActive = false;
    private int autocraftingTickCounter = 0;

    public void tick() {
        this.updateActive();
        if (this.wasActive && --this.autocraftingTickCounter <= 0) {
            this.autocraftingTickCounter = 5;
            this.updateAutocraftings();
        }
    }

    private void updateActive() {
        boolean isActive;
        boolean bl = isActive = this.isActive() && this.getLinkedModule() != null;
        if (this.wasActive != isActive) {
            this.onActiveChanged(isActive);
        }
        this.wasActive = isActive;
    }

    protected void onActiveChanged(boolean isActive) {
    }

    @Override
    public void link(NetworkStorageModule module) {
        if (module == null || module.isDestroyed()) {
            return;
        }
        IBuilding building = module.getBuilding();
        this.colonyId = building.getColony().getID();
        this.warehousePos = Optional.of(building.getID());
        this.module = module;
        this.module.onLink(this);
    }

    @Override
    public void unlink() {
        NetworkStorageModule module = this.getLinkedModule0();
        this.colonyId = 0;
        this.warehousePos = Optional.empty();
        this.module = null;
        if (module != null) {
            module.onUnlink(this);
            this.onUnlink(module);
        }
    }

    protected void onUnlink(NetworkStorageModule module) {
    }

    public boolean readLink(CompoundTag tag) {
        int colonyId = this.colonyId;
        Optional<BlockPos> warehousePos = this.warehousePos;
        this.colonyId = tag.getInt(TAG_COLONY_ID);
        this.warehousePos = tag.contains(TAG_WAREHOUSE_POS) ? Optional.of(BlockPosUtil.read((CompoundTag)tag, (String)TAG_WAREHOUSE_POS)) : Optional.empty();
        return this.colonyId != colonyId || !this.warehousePos.equals(warehousePos);
    }

    public CompoundTag writeLink() {
        CompoundTag tag = new CompoundTag();
        tag.putInt(TAG_COLONY_ID, this.colonyId);
        this.warehousePos.ifPresent(p -> BlockPosUtil.write((CompoundTag)tag, (String)TAG_WAREHOUSE_POS, (BlockPos)p));
        return tag;
    }

    public boolean readLink(RegistryFriendlyByteBuf buffer) {
        int colonyId = this.colonyId;
        Optional<BlockPos> warehousePos = this.warehousePos;
        this.colonyId = buffer.readInt();
        this.warehousePos = buffer.readOptional(FriendlyByteBuf::readBlockPos);
        return this.colonyId != colonyId || !this.warehousePos.equals(warehousePos);
    }

    public void writeLink(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.colonyId);
        buffer.writeOptional(this.warehousePos, FriendlyByteBuf::writeBlockPos);
    }

    public void readData(CompoundTag tag) {
    }

    public CompoundTag writeData() {
        CompoundTag tag = new CompoundTag();
        this.writeData(tag);
        return tag;
    }

    public void writeData(CompoundTag tag) {
    }

    @Override
    public Optional<BlockPos> getLinkedPos() {
        return this.warehousePos;
    }

    @Override
    public NetworkStorageModule getLinkedModule() {
        NetworkStorageModule module = this.getLinkedModule0();
        if (module == null || module.isDestroyed()) {
            if (!this.warehousePos.isEmpty()) {
                this.unlink();
            }
            return null;
        }
        return module;
    }

    @Override
    public NetworkStorageModuleView getLinkedModuleView() {
        if (this.warehousePos.isEmpty()) {
            return null;
        }
        IColonyView colony = MinecoloniesAPIProxy.getInstance().getColonyManager().getColonyView(this.colonyId, this.getLevel().dimension());
        if (colony == null) {
            return null;
        }
        IBuildingView building = (IBuildingView)colony.getClientBuildingManager().getBuilding(this.warehousePos.get());
        if (building == null) {
            return null;
        }
        return (NetworkStorageModuleView)building.getModuleView(ModBuildingModules.NETWORK_STORAGE);
    }

    private NetworkStorageModule getLinkedModule0() {
        if (this.module == null) {
            if (this.warehousePos.isEmpty()) {
                return null;
            }
            IColony colony = MinecoloniesAPIProxy.getInstance().getColonyManager().getColonyByWorld(this.colonyId, this.getLevel());
            if (colony == null) {
                return null;
            }
            IBuilding building = (IBuilding)colony.getServerBuildingManager().getBuilding(this.warehousePos.get());
            if (building == null) {
                return null;
            }
            this.module = (NetworkStorageModule)building.getModule(ModBuildingModules.NETWORK_STORAGE);
        }
        return this.module;
    }

    protected NetworkCrafting getNetworkCrafting(IRequestManager requestManager, IToken<?> requestId) {
        CustomizableRequestable customizable;
        IRequest request = requestManager.getRequestForToken(requestId);
        if (request == null) {
            return null;
        }
        IRequestable iRequestable = request.getRequest();
        if (iRequestable instanceof CustomizableRequestable && (iRequestable = (customizable = (CustomizableRequestable)iRequestable).getObject()) instanceof NetworkCrafting) {
            NetworkCrafting networkCrafting = (NetworkCrafting)iRequestable;
            return networkCrafting;
        }
        return null;
    }

    protected IDeliverable getDeliverable(IRequestManager requestManager, IToken<?> requestId) {
        IRequest request = requestManager.getRequestForToken(requestId);
        if (request != null) {
            IToken parentId = request.getParent();
            if (parentId != null) {
                IRequestable iRequestable;
                IRequest parent = requestManager.getRequestForToken(parentId);
                if (parent != null && (iRequestable = parent.getRequest()) instanceof IDeliverable) {
                    IDeliverable deliverable = (IDeliverable)iRequestable;
                    return deliverable;
                }
            } else {
                IRequestable iRequestable = request.getRequest();
                if (iRequestable instanceof IDeliverable) {
                    IDeliverable deliverable = (IDeliverable)iRequestable;
                    return deliverable;
                }
            }
        }
        return null;
    }

    public boolean wasActive() {
        return this.wasActive;
    }
}

