/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common;

import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.api.common.building.module.NetworkStorageViewRegistry;
import steve_gall.minecolonies_compatibility.api.common.butcher.CustomizedButcherable;
import steve_gall.minecolonies_compatibility.api.common.requestsystem.IngredientDeliverable;
import steve_gall.minecolonies_compatibility.api.common.tool.CustomizedToolSystem;
import steve_gall.minecolonies_compatibility.core.client.MineColoniesCompatibilityClient;
import steve_gall.minecolonies_compatibility.core.common.CompatibilityManager;
import steve_gall.minecolonies_compatibility.core.common.block.entity.INetworkStorageViewHolder;
import steve_gall.minecolonies_compatibility.core.common.building.module.InjectBuildingSettingsModuleEvent;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigCommon;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.crafting.BucketFillingRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.crafting.SmithingRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.crafting.SmithingTemplateRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.crafting.StonecutterRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.butcher.Butcherable;
import steve_gall.minecolonies_compatibility.core.common.init.ModBlockEntities;
import steve_gall.minecolonies_compatibility.core.common.init.ModBlocks;
import steve_gall.minecolonies_compatibility.core.common.init.ModBuildingModules;
import steve_gall.minecolonies_compatibility.core.common.init.ModCraftingTypes;
import steve_gall.minecolonies_compatibility.core.common.init.ModDataComponents;
import steve_gall.minecolonies_compatibility.core.common.init.ModGuardTypes;
import steve_gall.minecolonies_compatibility.core.common.init.ModInteractions;
import steve_gall.minecolonies_compatibility.core.common.init.ModItems;
import steve_gall.minecolonies_compatibility.core.common.init.ModJobs;
import steve_gall.minecolonies_compatibility.core.common.init.ModMenuTypes;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;
import steve_gall.minecolonies_compatibility.core.common.network.ModMessagesRegistrar;
import steve_gall.minecolonies_compatibility.core.common.requestsystem.NetworkCrafting;
import steve_gall.minecolonies_compatibility.core.common.requestsystem.NetworkCraftingProductionResolverFactory;
import steve_gall.minecolonies_compatibility.core.common.requestsystem.NetworkCraftingRequestResolverFactory;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;
import steve_gall.minecolonies_tweaks.api.common.building.module.ModuleRegisterEvent;
import steve_gall.minecolonies_tweaks.api.common.crafting.CustomizedRecipeStorageRegistry;
import steve_gall.minecolonies_tweaks.api.common.network.MessageRegistrar;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.DeliverableObjectRegistry;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.RequestableObjectRegistry;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolTypeRegisterEvent;

@Mod(value="minecolonies_compatibility")
public class MineColoniesCompatibility {
    public static final String MOD_ID = "minecolonies_compatibility";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final CompatibilityManager COMPAT = new CompatibilityManager();

    public MineColoniesCompatibility(FMLModContainer modContainer, Dist dist) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MineColoniesCompatibilityConfigCommon.SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MineColoniesCompatibilityConfigServer.SPEC);
        IEventBus fml_bus = modContainer.getEventBus();
        ModDataComponents.REGISTER.register(fml_bus);
        ModBlocks.REGISTER.register(fml_bus);
        ModItems.REGISTER.register(fml_bus);
        ModBlockEntities.REGISTER.register(fml_bus);
        ModGuardTypes.REGISTER.register(fml_bus);
        ModJobs.REGISTER.register(fml_bus);
        ModCraftingTypes.REGISTER.register(fml_bus);
        ModMenuTypes.REGISTER.register(fml_bus);
        ModInteractions.REGISTER.register(fml_bus);
        fml_bus.addListener(this::onFMLCommonSetup);
        fml_bus.addListener(this::onModuleRegister);
        fml_bus.addListener(this::onCustomToolTypeRegister);
        fml_bus.addListener(this::onBuildCreativeModeTabContents);
        fml_bus.addListener(this::onRegisterPayloadHandlers);
        IEventBus forge_bus = NeoForge.EVENT_BUS;
        forge_bus.addListener(this::onInjectBuildingSettingsModule);
        forge_bus.addListener(this::onRecipesUpdated);
        forge_bus.addListener(this::onOnDatapackSync);
        ModuleManager.initialize();
        CustomizedRecipeStorageRegistry.INSTANCE.register(BucketFillingRecipeStorage.ID, BucketFillingRecipeStorage::serialize, BucketFillingRecipeStorage::deserialize);
        CustomizedRecipeStorageRegistry.INSTANCE.register(SmithingRecipeStorage.ID, SmithingRecipeStorage::serialize, SmithingRecipeStorage::deserialize);
        CustomizedRecipeStorageRegistry.INSTANCE.register(SmithingTemplateRecipeStorage.ID, SmithingTemplateRecipeStorage::serialize, SmithingTemplateRecipeStorage::deserialize);
        CustomizedRecipeStorageRegistry.INSTANCE.register(StonecutterRecipeStorage.ID, StonecutterRecipeStorage::serialize, StonecutterRecipeStorage::deserialize);
        StandardFactoryController.getInstance().registerNewFactory((IFactory)new NetworkCraftingRequestResolverFactory());
        StandardFactoryController.getInstance().registerNewFactory((IFactory)new NetworkCraftingProductionResolverFactory());
        RequestableObjectRegistry.INSTANCE.register(NetworkCrafting.ID, NetworkCrafting::serialize, NetworkCrafting::deserialize);
        DeliverableObjectRegistry.INSTANCE.register(IngredientDeliverable.ID, IngredientDeliverable::serialize, IngredientDeliverable::deserialize);
        DeliverableObjectRegistry.INSTANCE.register(Butcherable.ID, Butcherable::serialize, Butcherable::deserialize);
        if (dist.isClient()) {
            new MineColoniesCompatibilityClient(modContainer);
        }
    }

    private void onFMLCommonSetup(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            COMPAT.initialize();
            CustomizedToolSystem.registerDurabilityBasedLevel((EquipmentTypeEntry)ModEquipmentTypes.bow.get());
            CustomizedToolSystem.registerDurabilityBasedLevel((EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get());
            CustomizedToolSystem.registerDurabilityBasedLevel((EquipmentTypeEntry)ModEquipmentTypes.shears.get());
            CustomizedToolSystem.registerDurabilityBasedLevel((EquipmentTypeEntry)ModEquipmentTypes.shield.get());
            CustomizedToolSystem.registerDurabilityBasedLevel((EquipmentTypeEntry)ModEquipmentTypes.flint_and_steel.get());
            NetworkStorageViewRegistry.register((be, direction) -> {
                INetworkStorageView iNetworkStorageView;
                if (be instanceof INetworkStorageViewHolder) {
                    INetworkStorageViewHolder blockEntity = (INetworkStorageViewHolder)be;
                    iNetworkStorageView = blockEntity.getNetworkStorageView();
                } else {
                    iNetworkStorageView = null;
                }
                return iNetworkStorageView;
            });
        });
    }

    private void onModuleRegister(ModuleRegisterEvent e) {
        ((BuildingEntry)ModBuildings.guardTower.get()).getModuleProducers().add(ModBuildingModules.GUNNER_TOWER_WORK);
        ((BuildingEntry)ModBuildings.barracksTower.get()).getModuleProducers().add(ModBuildingModules.GUNNER_BARRACKS_WORK);
        ((BuildingEntry)ModBuildings.lumberjack.get()).getModuleProducers().add(ModBuildingModules.ORCHARDIST_WORK);
        ((BuildingEntry)ModBuildings.lumberjack.get()).getModuleProducers().add(ModBuildingModules.FRUITLIST_BLACKLIST);
        ((BuildingEntry)ModBuildings.wareHouse.get()).getModuleProducers().add(ModBuildingModules.NETWORK_STORAGE);
        ((BuildingEntry)ModBuildings.blacksmith.get()).getModuleProducers().add(ModBuildingModules.BLACKSMITH_SMITHING);
        ((BuildingEntry)ModBuildings.blacksmith.get()).getModuleProducers().add(ModBuildingModules.BLACKSMITH_SMITHING_TEMPLATE_CRAFTING);
        ((BuildingEntry)ModBuildings.deliveryman.get()).getModuleProducers().add(ModBuildingModules.FLUID_MANAGER_WORK);
        ((BuildingEntry)ModBuildings.deliveryman.get()).getModuleProducers().add(ModBuildingModules.FLUID_MANAGER_BUCKET_FILLING);
        ((BuildingEntry)ModBuildings.deliveryman.get()).getModuleProducers().add(ModBuildingModules.FLUID_MANAGER_LAVA_CAULDRON);
        ((BuildingEntry)ModBuildings.swineHerder.get()).getModuleProducers().add(ModBuildingModules.BUTCHER_WORK);
        ((BuildingEntry)ModBuildings.swineHerder.get()).getModuleProducers().add(ModBuildingModules.BUTCHERABLELIST_BLACKLIST);
        ((BuildingEntry)ModBuildings.chickenHerder.get()).getModuleProducers().add(ModBuildingModules.BUTCHER_WORK);
        ((BuildingEntry)ModBuildings.chickenHerder.get()).getModuleProducers().add(ModBuildingModules.BUTCHERABLELIST_BLACKLIST);
        ((BuildingEntry)ModBuildings.cowboy.get()).getModuleProducers().add(ModBuildingModules.BUTCHER_WORK);
        ((BuildingEntry)ModBuildings.cowboy.get()).getModuleProducers().add(ModBuildingModules.BUTCHERABLELIST_BLACKLIST);
        ((BuildingEntry)ModBuildings.rabbitHutch.get()).getModuleProducers().add(ModBuildingModules.BUTCHER_WORK);
        ((BuildingEntry)ModBuildings.rabbitHutch.get()).getModuleProducers().add(ModBuildingModules.BUTCHERABLELIST_BLACKLIST);
        ((BuildingEntry)ModBuildings.shepherd.get()).getModuleProducers().add(ModBuildingModules.BUTCHER_WORK);
        ((BuildingEntry)ModBuildings.shepherd.get()).getModuleProducers().add(ModBuildingModules.BUTCHERABLELIST_BLACKLIST);
        ((BuildingEntry)ModBuildings.stoneMason.get()).getModuleProducers().add(ModBuildingModules.STONEMASON_STONECUTTING);
    }

    private void onCustomToolTypeRegister(CustomToolTypeRegisterEvent e) {
        e.register(ModToolTypes.CROSSBOW);
        e.register(ModToolTypes.GUN);
        e.register(ModToolTypes.KNIFE);
        e.register((CustomToolType)ModToolTypes.RANGER_WEAPON);
        e.register((CustomToolType)ModToolTypes.KNIGHT_WEAPON);
        e.register((CustomToolType)ModToolTypes.BUTCHER_TOOL);
    }

    private void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent e) {
        if (e.getTab() == ModCreativeTabs.GENERAL.get()) {
            e.accept((ItemLike)ModItems.COMMON_NETWORK_STORAGE.get());
        }
    }

    private void onInjectBuildingSettingsModule(InjectBuildingSettingsModuleEvent e) {
        BuildingEntry buildingType = e.getBuilding().getBuildingType();
        if (buildingType == ModBuildings.guardTower.get()) {
            e.register((BuildingEntry.ModuleProducer<? extends ISettingsModule, ? extends ISettingsModuleView>)BuildingModules.GUARD_SETTINGS, ModBuildingModules.GUARD_SETTINGS);
        } else if (buildingType == ModBuildings.barracksTower.get()) {
            e.register((BuildingEntry.ModuleProducer<? extends ISettingsModule, ? extends ISettingsModuleView>)BuildingModules.GUARD_SETTINGS, ModBuildingModules.GUARD_SETTINGS);
        } else if (buildingType == ModBuildings.lumberjack.get()) {
            e.register((BuildingEntry.ModuleProducer<? extends ISettingsModule, ? extends ISettingsModuleView>)BuildingModules.FORESTER_SETTINGS, ModBuildingModules.ORCHARDIST_SETTINGS);
        } else if (buildingType == ModBuildings.blacksmith.get()) {
            e.register((BuildingEntry.ModuleProducer<? extends ISettingsModule, ? extends ISettingsModuleView>)BuildingModules.SETTINGS_CRAFTER_RECIPE, ModBuildingModules.BLACKSMITH_SETTINGS);
        }
    }

    private void onRecipesUpdated(RecipesUpdatedEvent e) {
        this.reloadRecipeBaseds(e.getRecipeManager());
    }

    private void onOnDatapackSync(OnDatapackSyncEvent e) {
        if (e.getPlayer() == null) {
            this.reloadRecipeBaseds(e.getPlayerList().getServer().getRecipeManager());
        }
    }

    private void reloadRecipeBaseds(RecipeManager recipeManager) {
        CustomizedButcherable.reload(recipeManager);
        Butcherable.reload();
        ModuleManager.LOADED_MODULES.forEach(m -> m.onRecipeReloaded(recipeManager));
    }

    private void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        String modVersion = ((ModContainer)ModList.get().getModContainerById(MOD_ID).get()).getModInfo().getVersion().toString();
        MessageRegistrar registry = new MessageRegistrar(event.registrar(MOD_ID).versioned(modVersion));
        ModMessagesRegistrar.register(registry);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static String tl(String path) {
        return "minecolonies_compatibility." + path;
    }
}

