/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client.gui;

import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import steve_gall.minecolonies_compatibility.core.client.gui.TeachRecipeScreen;
import steve_gall.minecolonies_compatibility.core.common.inventory.ModuleMenu;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public abstract class TeachCraftingRecipeScreen<MENU extends TeachRecipeMenu<RECIPE, ?>, RECIPE>
extends TeachRecipeScreen<MENU, RECIPE> {
    private static final Component TEXT_WARNING_MAXIMUM_NUMBER_RECIPES = Component.translatable((String)"com.minecolonies.coremod.gui.recipe.full");
    protected final CraftingModuleView module;

    public TeachCraftingRecipeScreen(MENU menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.module = (CraftingModuleView)((ModuleMenu)((Object)menu)).getModulePos().getModuleView();
    }

    @Override
    protected Component getError() {
        if (!this.module.canLearn(this.getCraftingType())) {
            return TEXT_WARNING_MAXIMUM_NUMBER_RECIPES;
        }
        return super.getError();
    }

    @Override
    protected void onDone(RECIPE recipe, List<ItemStorage> input) {
        IRecipeStorage storage = this.createRecipeStorage(recipe, input).wrap();
        PacketDistributor.sendToServer((CustomPacketPayload)new AddRemoveRecipeMessage(this.module.getBuildingView(), false, storage, this.module.getProducer().getRuntimeID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public abstract CraftingType getCraftingType();

    protected abstract ICustomizedRecipeStorage createRecipeStorage(RECIPE var1, List<ItemStorage> var2);

    public CraftingModuleView getModule() {
        return this.module;
    }
}

