/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmithingRecipe;
import steve_gall.minecolonies_compatibility.core.client.gui.TeachCraftingRecipeScreen;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.crafting.SmithingRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.init.ModCraftingTypes;
import steve_gall.minecolonies_compatibility.core.common.inventory.SmithingTeachMenu;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public class SmithingTeachScreen
extends TeachCraftingRecipeScreen<SmithingTeachMenu, RecipeHolder<SmithingRecipe>> {
    public static final ResourceLocation TEXTURE = MineColoniesCompatibility.rl("textures/gui/smithing_teach.png");

    public SmithingTeachScreen(SmithingTeachMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public CraftingType getCraftingType() {
        return (CraftingType)ModCraftingTypes.SMITHING.get();
    }

    @Override
    protected ICustomizedRecipeStorage createRecipeStorage(RecipeHolder<SmithingRecipe> recipe, List<ItemStorage> input) {
        ItemStorage template = input.get(0);
        ItemStorage base = input.get(1);
        ItemStorage addition = input.get(2);
        ItemStack result = ((SmithingTeachMenu)this.menu).getResultContainer().getItem(0);
        return new SmithingRecipeStorage(recipe.id(), template, base, addition, result);
    }
}

