/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.entity.ai.guard;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.InventoryUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizedAIGuard;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.GunnerAmmo;
import steve_gall.minecolonies_compatibility.core.common.building.BuildingHelper;
import steve_gall.minecolonies_compatibility.core.common.colony.CitizenHelper;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.AttackDelayConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.MoveSpeedConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.SearchRangeConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.BulletMode;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.GunnerConfig;
import steve_gall.minecolonies_compatibility.core.common.init.ModGuardTypes;
import steve_gall.minecolonies_compatibility.core.common.init.ModJobs;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableDeliverable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public abstract class CustomizedAIGunner
extends CustomizedAIGuard {
    @Override
    @NotNull
    public GuardType getGuardType() {
        return (GuardType)ModGuardTypes.GUNNER.get();
    }

    public GunnerConfig getJobConfig() {
        return MineColoniesCompatibilityConfigServer.INSTANCE.jobs.gunner;
    }

    @NotNull
    public BulletMode getBulletMode() {
        return (BulletMode)((Object)this.getJobConfig().bulletMode.get());
    }

    @Override
    @NotNull
    public JobEntry getJobEntry() {
        return (JobEntry)ModJobs.GUNNER.get();
    }

    protected abstract boolean testAmmo(@NotNull AbstractEntityCitizen var1, @NotNull ItemStack var2);

    @NotNull
    protected Predicate<ItemStack> getAmmoPredicate(@NotNull AbstractEntityCitizen user) {
        return stack -> this.testAmmo(user, (ItemStack)stack);
    }

    public int getAmmoSlot(@NotNull AbstractEntityCitizen user, @NotNull IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!this.testAmmo(user, inventory.getStackInSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public void insertItem(@NotNull AbstractEntityCitizen user, @NotNull IItemHandler inventory, @NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
        if (!result.isEmpty()) {
            BehaviorUtils.throwItem((LivingEntity)user, (ItemStack)result.copy(), (Vec3)user.position());
        }
    }

    public boolean requestAmmo(@NotNull AbstractEntityCitizen user, int minCount, boolean async) {
        GunnerAmmo request;
        if (!this.getBulletMode().canUse()) {
            return false;
        }
        ICitizenData citizen = user.getCitizenData();
        if (!CitizenHelper.isRequested(citizen, CustomizableDeliverable.TYPE_TOKEN, r -> {
            GunnerAmmo ammo;
            IDeliverableObject patt0$temp = ((CustomizableDeliverable)r.getRequest()).getObject();
            return patt0$temp instanceof GunnerAmmo && this.isAmmoRequest(user, ammo = (GunnerAmmo)patt0$temp) && async == citizen.getJob().getAsyncRequests().contains(r.getId());
        }) && (request = this.createAmmoRequest(user, minCount)) != null) {
            citizen.getWorkBuilding().createRequest(citizen, (IRequestable)new CustomizableDeliverable((IDeliverableObject)request), async);
            return true;
        }
        return false;
    }

    public boolean requestAmmo(@NotNull AbstractEntityCitizen user, boolean spare) {
        int ammoInBuilding;
        int ammoInInventory;
        if (!this.getBulletMode().canUse()) {
            return false;
        }
        if (spare && (ammoInInventory = InventoryUtils.getItemCountInItemHandler((IItemHandler)user.getInventoryCitizen(), this.getAmmoPredicate(user))) + (ammoInBuilding = InventoryUtils.getItemCountInProvider((IItemHandlerCapProvider)user.getCitizenData().getWorkBuilding(), this.getAmmoPredicate(user))) >= this.getAmmoMinRequestCount(user)) {
            return false;
        }
        return this.requestAmmo(user, this.getAmmoMinRequestCount(user), spare || this.getBulletMode().canDefault());
    }

    @Nullable
    protected abstract GunnerAmmo createAmmoRequest(@NotNull AbstractEntityCitizen var1, int var2);

    protected abstract boolean isAmmoRequest(@NotNull AbstractEntityCitizen var1, @NotNull GunnerAmmo var2);

    protected int getAmmoMinRequestCount(@NotNull AbstractEntityCitizen user) {
        return 64;
    }

    public boolean takeAmmo(@NotNull AbstractEntityCitizen user) {
        ICitizenData citizen = user.getCitizenData();
        IBuilding building = citizen.getWorkBuilding();
        InventoryCitizen inventory = citizen.getInventory();
        int takeAmount = this.getAmmoMinRequestCount(user);
        return InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler((IItemHandlerCapProvider)building, this.getAmmoPredicate(user), (int)takeAmount, (IItemHandler)inventory);
    }

    @Override
    public void onSelected(@NotNull AbstractEntityCitizen user) {
        super.onSelected(user);
        this.cancelExcessiveRequests(user);
        this.checkAmmo(user);
    }

    private void cancelExcessiveRequests(@NotNull AbstractEntityCitizen user) {
        ICitizenData citizen = user.getCitizenData();
        List requests = CitizenHelper.getRequests(citizen, CustomizableDeliverable.TYPE_TOKEN, r -> ((CustomizableDeliverable)r.getRequest()).getObject() instanceof GunnerAmmo);
        IRequestManager requestManager = citizen.getColony().getRequestManager();
        for (int i = 2; i < requests.size(); ++i) {
            requestManager.updateRequestState(requests.get(i).getId(), RequestState.CANCELLED);
        }
    }

    @Override
    public void tick(@NotNull AbstractEntityCitizen user) {
        super.tick(user);
        if (this.isReloadTimerRunning(user)) {
            this.onReloadTimerRunning(user);
        }
    }

    @Override
    public void atBuildingActions(@NotNull AbstractEntityCitizen user) {
        super.atBuildingActions(user);
        BulletMode bulletMode = this.getBulletMode();
        if (bulletMode.canUse()) {
            ICitizenData citizen = user.getCitizenData();
            this.takeAmmo(user);
            int ammoCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)citizen.getInventory(), this.getAmmoPredicate(user));
            this.requestAmmo(user, ammoCount > 0 || bulletMode.canDefault());
        }
        this.setNeedPrepare(user, false);
        this.reload(user, false);
    }

    public boolean checkAmmo(@NotNull AbstractEntityCitizen user) {
        BulletMode bulletMode = this.getBulletMode();
        if (bulletMode.canUse() && this.isNeedRequestAmmo(user)) {
            boolean canDefault = bulletMode.canDefault();
            if (!canDefault) {
                this.setNeedPrepare(user, true);
            }
            this.requestAmmo(user, canDefault);
            return canDefault;
        }
        return true;
    }

    protected boolean isNeedRequestAmmo(@NotNull AbstractEntityCitizen user) {
        return this.getAmmoSlot(user, (IItemHandler)user.getInventoryCitizen()) == -1;
    }

    @Override
    public void onTargetChange(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        super.onTargetChange(user, target);
        this.reload(user, false);
        this.requestAmmo(user, true);
    }

    @Override
    public void onTargetReset(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        super.onTargetReset(user, target);
        this.reload(user, false);
        this.requestAmmo(user, true);
    }

    @Override
    public final boolean canAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        if (user.distanceTo((Entity)target) <= 2.0f && this.canMeleeAttack(user, target)) {
            return true;
        }
        return this.canRangedAttack(user, target);
    }

    public boolean canMeleeAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        return false;
    }

    public abstract boolean reload(@NotNull AbstractEntityCitizen var1, boolean var2);

    public boolean canRangedAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        if (!this.checkAmmo(user)) {
            return false;
        }
        if (this.isReloadTimerRunning(user) && !this.onReloadTimerRunning(user)) {
            return false;
        }
        return this.reload(user, true);
    }

    @Override
    public final void doAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        if (user.distanceTo((Entity)target) <= 2.0f && this.canMeleeAttack(user, target)) {
            this.doMeleeAttack(user, target);
        } else if (this.canRangedAttack(user, target)) {
            this.doRangedAttack(user, target);
        }
    }

    public void doMeleeAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        Holder.Reference damageType = user.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageSourceKeys.GUARD);
        DamageSource source = new DamageSource((Holder)damageType, (Entity)user);
        float damage = this.getMeleeAttackDamage(user, target);
        damage = (float)((double)damage + (double)EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)user.level()), (ItemStack)this.getMainHandItem(user), (Entity)target, (DamageSource)source, (float)damage) / 2.5);
        target.hurt(source, damage);
    }

    public float getMeleeAttackDamage(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        return 1.0f;
    }

    public abstract void doRangedAttack(@NotNull AbstractEntityCitizen var1, @NotNull LivingEntity var2);

    @Override
    public int getAttackDelay(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        AttackDelayConfig config = this.getAttackDealyConfig();
        if (config != null) {
            return config.apply(user, this.getSecondarySkillLevel(user));
        }
        return 0;
    }

    @Nullable
    protected abstract AttackDelayConfig getAttackDealyConfig();

    @Override
    public double getAttackDistance(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        GunnerConfig config = this.getJobConfig();
        return config.attackRange.apply(user, this.getSecondarySkillLevel(user), target);
    }

    @Override
    public double getHorizontalSearchRange(@NotNull AbstractEntityCitizen user) {
        return ((Integer)this.getJobConfig().searchRange.horizontal.get()).doubleValue();
    }

    @Override
    public double getVerticalSearchRange(@NotNull AbstractEntityCitizen user) {
        SearchRangeConfig config = this.getJobConfig().searchRange;
        int range = (Integer)config.vertical.get();
        if (BuildingHelper.IsGuardsTask(user.getCitizenData().getWorkBuilding(), "com.minecolonies.core.guard.setting.guard")) {
            range += ((Integer)config.verticalBonusOnGuard.get()).intValue();
        }
        return range;
    }

    @Override
    public double getCombatMovementSpeed(@NotNull AbstractEntityCitizen user) {
        MoveSpeedConfig config = this.getJobConfig().combatMoveSpeed;
        return config.apply(user, this.getPrimarySkillLevel(user));
    }

    protected boolean onReloadTimerRunning(@NotNull AbstractEntityCitizen user) {
        if (this.isReloadTimerComplete(user)) {
            this.stopReloadTimer(user, true);
            return true;
        }
        return false;
    }

    protected void onReloadTimerStarted(@NotNull AbstractEntityCitizen user) {
        user.swing(InteractionHand.MAIN_HAND);
    }

    protected void onReloadTimerStopped(@NotNull AbstractEntityCitizen user, boolean complete) {
        user.swing(InteractionHand.MAIN_HAND);
    }

    protected int getReloadTimerDuration() {
        return 0;
    }

    protected boolean isReloadTimerComplete(@NotNull AbstractEntityCitizen user) {
        int reloadDuration;
        int reloadTime = this.getReloadTimerElapsed(user);
        return reloadTime >= (reloadDuration = this.getReloadTimerDuration());
    }

    protected int getReloadTimerElapsed(@NotNull AbstractEntityCitizen user) {
        long current = user.level().getGameTime();
        long started = this.getOrEmptyTag(user).getLong("reloadStarted");
        return (int)(current - started);
    }

    protected boolean isReloadTimerRunning(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).getLong("reloadStarted") > 0L;
    }

    protected void startReloadTimer(@NotNull AbstractEntityCitizen user) {
        this.getOrCreateTag(user).putLong("reloadStarted", user.level().getGameTime());
        this.onReloadTimerStarted(user);
    }

    protected void stopReloadTimer(@NotNull AbstractEntityCitizen user, boolean complete) {
        this.getOrCreateTag(user).remove("reloadStarted");
        this.onReloadTimerStopped(user, complete);
    }

    @Override
    public boolean isNeedPrepare(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).getBoolean("needPrepare");
    }

    protected void setNeedPrepare(@NotNull AbstractEntityCitizen user, boolean needPrepare) {
        this.getOrCreateTag(user).putBoolean("needPrepare", needPrepare);
    }
}

