/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.building.module;

import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.NetworkCraftingDestination;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModuleView;

public interface INetworkStorageView {
    @NotNull
    public Level getLevel();

    @NotNull
    public BlockPos getPos();

    @Nullable
    public Direction getDirection();

    @NotNull
    public ItemStack getIcon();

    public boolean isActive();

    public void link(@NotNull NetworkStorageModule var1);

    public void unlink();

    @NotNull
    public Optional<BlockPos> getLinkedPos();

    @Nullable
    public NetworkStorageModule getLinkedModule();

    @Nullable
    public NetworkStorageModuleView getLinkedModuleView();

    @NotNull
    default public NetworkCraftingDestination getNetworkCraftingDestination() {
        return NetworkCraftingDestination.VIEW;
    }

    default public boolean canRequest() {
        NetworkCraftingDestination destination = this.getNetworkCraftingDestination();
        return destination == NetworkCraftingDestination.VIEW && this.canExtract() || destination == NetworkCraftingDestination.BUILDING;
    }

    public boolean canExtract();

    public boolean canInsert();

    @NotNull
    public Stream<ItemStack> getAllStacks();

    @NotNull
    public ItemStack extractItem(@NotNull ItemStack var1, boolean var2);

    @NotNull
    public ItemStack insertItem(@NotNull ItemStack var1, boolean var2);

    @NotNull
    default public ItemStack calculateAutocrafting(@NotNull IDeliverable deliverable) {
        return ItemStack.EMPTY;
    }

    default public void cancelAutocrafting(@NotNull IToken<?> requestId) {
    }

    default public void createAutocrafting(@NotNull IToken<?> requestId) {
    }

    default public void updateAutocraftings() {
    }
}

